/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.SegmentMatch;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class ArtifactIdFilter
implements Filter {
    protected SegmentMatch matcher;

    public ArtifactIdFilter(String pattern) {
        this(SegmentMatch.parse(pattern));
    }

    public ArtifactIdFilter(SegmentMatch matcher) {
        this.matcher = matcher;
    }

    public boolean match(String segment) {
        return this.matcher.match(segment);
    }

    public boolean accept(Dependency dep) {
        return this.matcher.match(dep.getArtifactId());
    }

    public boolean accept(Edge edge) {
        return this.matcher.match(edge.dst.getArtifact().getArtifactId());
    }

    public boolean accept(Artifact artifact) {
        return this.matcher.match(artifact.getArtifactId());
    }

    public boolean accept(Node node) {
        return this.accept(node.getArtifact());
    }

    public String toString() {
        return "" + this.getClass() + " [" + this.matcher + "]";
    }
}

