/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.nuxeo.build.ant.artifact.GraphTask;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.maven.graph.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    protected MavenClient maven;
    protected LinkedList<Node> roots = new LinkedList();
    protected TreeMap<String, Node> nodes = new TreeMap();
    protected Resolver resolver = new Resolver(this);
    protected Map<String, Artifact> file2artifacts = new HashMap<String, Artifact>();

    public Graph(MavenClient maven) {
        this.maven = maven;
    }

    public MavenClient getMaven() {
        return this.maven;
    }

    public List<Node> getRoots() {
        return this.roots;
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public Artifact getArtifactByFile(String fileName) {
        return this.file2artifacts.get(fileName);
    }

    public void collectNodes(Collection<Node> nodes) {
        for (Node node : this.roots) {
            node.collectNodes(nodes);
        }
    }

    public void collectNodes(Collection<Node> nodes, Filter filter) {
        for (Node node : this.roots) {
            node.collectNodes(nodes, filter);
        }
    }

    public Node[] getNodesArray() {
        return this.nodes.values().toArray(new Node[this.nodes.size()]);
    }

    public TreeMap<String, Node> getNodesTree() {
        return this.nodes;
    }

    public Node findFirst(String pattern) {
        return this.findFirst(pattern, false);
    }

    public Node findFirst(String pattern, boolean stopIfNotUnique) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        int size = map.size();
        if (size == 0) {
            return null;
        }
        if (stopIfNotUnique && size > 1) {
            throw new BuildException("Pattern '" + pattern + "' cannot be resolved to a unique node. Matching nodes are: " + map.values());
        }
        return (Node)map.get(map.firstKey());
    }

    public Collection<Node> find(String pattern) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        return map.values();
    }

    public Node addRootNode(MavenProject pom) throws ArtifactNotFoundException {
        Artifact artifact = pom.getArtifact();
        String key = Node.createNodeId(artifact);
        Node node = this.nodes.get(key);
        if (node == null) {
            node = new Node(this, pom, artifact, key);
            this.nodes.put(node.getId(), node);
            this.roots.add(node);
        }
        return node;
    }

    public Node addRootNode(String key) throws ArtifactNotFoundException {
        ArtifactDescriptor ad = new ArtifactDescriptor(key);
        Artifact artifact = GraphTask.readArtifact(ad);
        return this.getRootNode(artifact);
    }

    public Node getRootNode(Artifact artifact) throws ArtifactNotFoundException {
        String key = Node.createNodeId(artifact);
        Node node = this.nodes.get(key);
        if (node == null) {
            node = new Node(this, null, artifact, key);
            this.nodes.put(node.getId(), node);
            this.roots.add(node);
        }
        return node;
    }

    public Node getNode(Artifact artifact) throws ArtifactNotFoundException {
        String key = Node.createNodeId(artifact);
        Node node = this.nodes.get(key);
        if (node == null) {
            node = new Node(this, null, artifact, key);
            this.nodes.put(node.getId(), node);
        }
        return node;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public Node lookup(String id) {
        return this.nodes.get(id);
    }

    public Node lookup(Artifact artifact) {
        return this.lookup(Node.createNodeId(artifact));
    }

    public Node findNode(ArtifactDescriptor ad) {
        String key = ad.getNodeKeyPattern();
        Collection<Node> nodes = null;
        nodes = key == null ? this.getNodes() : this.find(key);
        for (Node node : nodes) {
            Artifact arti = node.getArtifact();
            if (ad.artifactId != null && !ad.artifactId.equals(arti.getArtifactId()) || ad.groupId != null && !ad.groupId.equals(arti.getGroupId()) || ad.version != null && !ad.version.equals(arti.getVersion()) || ad.type != null && !ad.type.equals(arti.getType())) continue;
            return node;
        }
        return null;
    }

    public MavenProject loadPom(Artifact artifact) {
        if ("system".equals(artifact.getScope())) {
            return null;
        }
        try {
            return this.maven.getProjectBuilder().buildFromRepository(this.maven.getArtifactFactory().createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), this.maven.getRemoteRepositories(), this.maven.getLocalRepository());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        map.put("org.nuxeo:core:", "org.nuxeo:core");
        map.put("org.nuxeo:core:e", "org.nuxeo:coree");
        map.put("org.nuxeo:coree", "org.nuxeo:core:test");
        map.put("org.nuxeo:common", "org.nuxeo:common");
        map.put("org.nuxeo:clear", "org.nuxeo:clear");
        map.put("org.nuxeos", "org.nuxeos");
        map.put("com", "com");
        map.put("pom", "pom");
        map.put("a:b:c:d", "a:b:c:d");
        map.put("a:b:d", "a:b:d");
        map.put("b", "b");
        System.out.println(map);
        SortedMap smap = map.subMap("org.nuxeo:core:", "org.nuxeo:core:\u0000");
        System.out.println(smap.size() + " - " + smap);
    }
}

