/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.build.maven.graph.AbstractGraphVisitor;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphVizExporter
extends AbstractGraphVisitor {
    protected final PrintWriter out;
    protected final Map<Object, String> colors = new HashMap<Object, String>();
    protected String nodeColor = "black";
    protected String edgeColor = "black";
    private Map<Node, String> ids = new HashMap<Node, String>();

    public GraphVizExporter(PrintWriter out) {
        this.out = out;
        out.println("digraph G {");
    }

    public GraphVizExporter(OutputStream out) {
        this(new PrintWriter(out));
    }

    public void setDefaultEdgeColor(String edgeColor) {
        this.edgeColor = edgeColor;
    }

    public void setDefaultNodeColor(String nodeColor) {
        this.nodeColor = nodeColor;
    }

    public void setColors(Collection<Node> nodes, String nodeColor) {
        for (Node node : nodes) {
            this.colors.put(node, nodeColor);
        }
    }

    public void setColors(Collection<Node> nodes, String nodeColor, String edgeColor) {
        for (Node node : nodes) {
            if (nodeColor != null) {
                this.colors.put(node, nodeColor);
            }
            if (edgeColor == null) continue;
            for (Edge edge : node.getEdgesOut()) {
                this.colors.put(edge, edgeColor);
            }
        }
    }

    public void setColor(Object key, String color) {
        this.colors.put(key, color);
    }

    public String getEdgeColor(Edge edge) {
        String color = this.colors.get(edge);
        return color != null ? color : this.edgeColor;
    }

    public String getNodeColor(Node node) {
        String color = this.colors.get(node);
        return color != null ? color : this.nodeColor;
    }

    public void close() {
        this.out.println("}");
        this.out.close();
    }

    @Override
    public boolean visitEdge(Edge edge) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (!"compile".equals(edge.scope)) {
            attrs.put("label", edge.scope);
        }
        if (edge.isOptional) {
            attrs.put("style", "dotted");
        }
        attrs.put("color", this.getEdgeColor(edge));
        if (edge.src.artifact.getGroupId().equals(edge.dst.artifact.getGroupId())) {
            attrs.put("weight", "10");
        }
        this.out.printf("%s -> %s ", this.id(edge.src), this.id(edge.dst));
        this.writeAttributes(attrs);
        return true;
    }

    @Override
    public boolean visitNode(Node node) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("label", node.artifact.getGroupId() + ':' + node.artifact.getArtifactId());
        attrs.put("color", this.getNodeColor(node));
        this.out.print(this.id(node) + ' ');
        this.writeAttributes(attrs);
        return true;
    }

    private void writeAttributes(Map<String, String> attributes) {
        this.out.print('[');
        boolean first = true;
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            if (e.getValue() == null) continue;
            this.out.printf("%s=\"%s\"", e.getKey(), e.getValue());
            if (!first) {
                this.out.print(',');
                continue;
            }
            first = false;
        }
        this.out.println("];");
    }

    private String id(Node n) {
        String id = this.ids.get(n);
        if (id == null) {
            id = "n" + this.ids.size();
            this.ids.put(n, id);
        }
        return id;
    }

    public void process(Graph graph, OutputStream out) {
        this.process(graph.getRoots());
    }

    public void process(Collection<Node> nodes, OutputStream out) throws IOException {
        GraphVizExporter viz = GraphVizExporter.createPng(out);
        super.process(nodes);
        viz.close();
    }

    public static GraphVizExporter createPng(final OutputStream out) throws IOException {
        ProcessBuilder pb = new ProcessBuilder("/usr/local/bin/dot", "-Tpng");
        final Process proc = pb.start();
        final Thread stdoutCopier = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        IOUtils.copy(proc.getInputStream(), out);
                    }
                    finally {
                        IOUtils.safeClose(out);
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        };
        stdoutCopier.start();
        new Thread(){

            public void run() {
                try {
                    IOUtils.copy(proc.getErrorStream(), System.err);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }.start();
        return new GraphVizExporter(proc.getOutputStream()){

            public void close() {
                super.close();
                try {
                    stdoutCopier.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
    }
}

