/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.resources.FileResource;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.AttachmentNode;
import org.nuxeo.build.maven.graph.Node;

public class ArtifactFile
extends FileResource {
    protected Node node;
    public String key;
    public ArtifactDescriptor ad = ArtifactDescriptor.emptyDescriptor();

    public void setKey(String pattern) {
        int p = pattern.lastIndexOf(59);
        if (p > -1) {
            this.key = pattern.substring(0, p);
            this.ad.classifier = pattern.substring(p + 1);
        } else {
            this.key = pattern;
        }
    }

    public void setArtifactId(String artifactId) {
        this.ad.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.ad.groupId = groupId;
    }

    public void setType(String type) {
        this.ad.type = type;
    }

    public void setVersion(String version) {
        this.ad.version = version;
    }

    public void setClassifier(String classifier) {
        this.ad.classifier = classifier;
    }

    public Node getNode() {
        if (this.node == null) {
            this.node = this.key != null ? MavenClientFactory.getInstance().getGraph().findFirst(this.key) : MavenClientFactory.getInstance().getGraph().findNode(this.ad);
            if (this.node == null) {
                throw new BuildException("Artifact with pattern " + (this.key != null ? this.key : this.ad.getNodeKeyPattern()) + " was not found in graph");
            }
            if (this.ad.classifier != null) {
                this.node = new AttachmentNode(this.node, this.ad.classifier);
            }
        }
        return this.node;
    }

    public File getFile() {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getFile();
        }
        return this.getNode().getFile();
    }

    public File getBaseDir() {
        return this.isReference() ? ((FileResource)this.getCheckedRef()).getBaseDir() : this.getFile().getParentFile();
    }
}

