/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.ant.artifact.Excludes;
import org.nuxeo.build.ant.artifact.Includes;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class ExpandTask
extends Task {
    public String key;
    public int depth = 1;
    public AndFilter filter = new AndFilter();

    public void setKey(String key) {
        this.key = key;
    }

    public void setDepth(String depth) {
        this.depth = "all".equals(depth) ? Integer.MAX_VALUE : Integer.parseInt(depth);
    }

    public void addExcludes(Excludes excludes) {
        this.filter.addFilter(excludes.getFilter());
    }

    public void addIncludes(Includes includes) {
        this.filter.addFilter(includes.getFilter());
    }

    protected boolean acceptNode(Node node) {
        return true;
    }

    public void execute() throws BuildException {
        Collection<Node> nodes = null;
        MavenClient maven = MavenClientFactory.getInstance();
        Graph graph = maven.getGraph();
        nodes = this.key == null ? graph.getRoots() : graph.find(this.key);
        for (Node node : nodes) {
            if (!this.acceptNode(node)) continue;
            graph.resolveDependencyTree(node, CompositeFilter.compact(this.filter), this.depth);
        }
    }
}

