/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import org.apache.maven.artifact.Artifact;
import org.nuxeo.build.ant.artifact.ExpandTask;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.NotFilter;
import org.nuxeo.build.maven.filter.VersionFilter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class NuxeoExpandTask
extends ExpandTask {
    public NuxeoExpandTask() {
        this.setDepth("all");
        Filter nuxeoFilter = new Filter(){

            @Override
            public boolean accept(Artifact artifact) {
                return true;
            }

            @Override
            public boolean accept(Edge edge) {
                if (edge.isOptional) {
                    return false;
                }
                String scope = edge.scope;
                if (scope == null) {
                    scope = "compile";
                }
                if ("compile".equals(scope)) {
                    return true;
                }
                return "runtime".equals(scope);
            }

            @Override
            public boolean accept(Node node) {
                return true;
            }
        };
        this.filter.addFilter(nuxeoFilter);
        this.filter.addFilter(new NotFilter(new VersionFilter("[*)")));
        this.filter.addFilter(new NotFilter(new GroupIdFilter("org.nuxeo.build")));
    }

    @Override
    protected boolean acceptNode(Node node) {
        return node.getArtifact().getGroupId().startsWith("org.nuxeo");
    }
}

