/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class PrintGraphTask
extends Task {
    private OutputStream output = System.out;

    public void execute() throws BuildException {
        HashSet<Node> colectedNodes = new HashSet<Node>();
        Graph graph = MavenClientFactory.getInstance().getGraph();
        for (Node node : graph.getRoots()) {
            try {
                this.print(" ", node, colectedNodes);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    protected void print(String tabs, Node node, Set<Node> collectedNodes) throws IOException {
        this.print(tabs + "" + node.toString() + System.getProperty("line.separator"));
        if (collectedNodes.contains(node)) {
            return;
        }
        collectedNodes.add(node);
        for (Edge edge : node.getEdgesOut()) {
            this.print(tabs + " |-- ", edge.out, collectedNodes);
        }
    }

    public void setOutput(String output) throws FileNotFoundException {
        this.output = new FileOutputStream(output);
    }

    private void print(String message) throws IOException {
        this.output.write(message.getBytes());
    }
}

