/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.ftl;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.ant.ftl.FreemarkerEngine;

public class ProcessTemplateTask
extends Task {
    public File baseDir;
    public String[] extensions = new String[]{"ftl"};
    public boolean removeExtension = true;
    public boolean removeTemplate = true;
    public boolean explicitRemoveTemplate = false;
    public Object input;
    public File toDir;
    public FreemarkerEngine engine;

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setExtension(String extension) {
        this.extensions = extension.trim().split("\\s*,\\s*");
    }

    public void setRemoveExtension(boolean removeExtension) {
        this.removeExtension = removeExtension;
    }

    public void setRemoveTemplate(boolean removeTemplate) {
        this.explicitRemoveTemplate = true;
        this.removeTemplate = removeTemplate;
    }

    public void setTodir(File toDir) {
        this.toDir = toDir;
    }

    public void execute() throws BuildException {
        if (this.engine == null) {
            this.engine = new FreemarkerEngine();
        }
        this.engine.setBaseDir(this.baseDir);
        if (this.toDir == null) {
            this.toDir = this.baseDir;
        } else if (!this.explicitRemoveTemplate) {
            this.removeTemplate = false;
        }
        this.toDir.mkdirs();
        File dir = this.baseDir;
        String relPath = "";
        this.processDirectory(dir, relPath);
    }

    public void processDirectory(File dir, String relPath) {
        block0: for (File file : dir.listFiles()) {
            String name = file.getName();
            if (file.isDirectory()) {
                this.processDirectory(file, relPath + "/" + name);
                continue;
            }
            int p = name.lastIndexOf(46);
            if (p <= -1) continue;
            String ext = name.substring(p + 1);
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!ext.equals(this.extensions[i])) continue;
                this.processFile(file, relPath + "/" + name, ext);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(File file, String relPath, String ext) {
        try {
            StringWriter writer = new StringWriter();
            if (this.input == null) {
                this.input = this.engine.createInput(this.getProject());
            }
            this.engine.process(this.input, relPath, (Writer)writer);
            if (this.removeExtension) {
                relPath = relPath.substring(0, relPath.length() - ext.length() - 1);
            }
            File f = new File(this.toDir, relPath);
            f.getParentFile().mkdirs();
            FileWriter out = new FileWriter(f);
            try {
                out.write(writer.getBuffer().toString());
            }
            finally {
                out.close();
            }
            if (this.removeTemplate) {
                file.delete();
            }
        }
        catch (Exception e) {
            throw new BuildException("Failed to process template: " + relPath, (Throwable)e);
        }
    }
}

