/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.nuxeo.build.ant.artifact.GraphTask;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.Logger;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.VersionManagement;
import org.nuxeo.build.maven.graph.AbstractGraphVisitor;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.maven.graph.Resolver;

public class Graph {
    protected MavenClient maven;
    protected Node root;
    protected final TreeMap<String, Node> nodes = new TreeMap();
    protected final LinkedList<Node> roots = new LinkedList();
    protected Resolver resolver = new Resolver(this);
    protected Map<String, Artifact> file2artifacts = new HashMap<String, Artifact>();
    protected VersionManagement vmgr;
    protected boolean shouldLoadDependencyManagement = false;
    protected final IdentityHashMap<Artifact, Node> nodesByArtifact = new IdentityHashMap();

    public Graph(MavenClient maven) {
        this.maven = maven;
        this.vmgr = new VersionManagement();
    }

    public VersionManagement getVersionManagement() {
        return this.vmgr;
    }

    public void setShouldLoadDependencyManagement(boolean shouldLoadDependencyManagement) {
        this.shouldLoadDependencyManagement = shouldLoadDependencyManagement;
    }

    public boolean shouldLoadDependencyManagement() {
        return this.shouldLoadDependencyManagement;
    }

    public MavenClient getMaven() {
        return this.maven;
    }

    public List<Node> getRoots() {
        return this.roots;
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public Artifact getArtifactByFile(String fileName) {
        return this.file2artifacts.get(fileName);
    }

    public void collectNodes(Collection<Node> nodesToCollect) {
        for (Node node : this.roots) {
            node.collectNodes(nodesToCollect);
        }
    }

    public void collectNodes(Collection<Node> nodesToCollect, Filter filter) {
        for (Node node : this.roots) {
            node.collectNodes(nodesToCollect, filter);
        }
    }

    public Node[] getNodesArray() {
        return this.nodes.values().toArray(new Node[this.nodes.size()]);
    }

    public Node findFirst(String pattern) {
        return this.findFirst(pattern, false);
    }

    public Node findFirst(String pattern, boolean stopIfNotUnique) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        int size = map.size();
        if (size == 0) {
            return null;
        }
        if (stopIfNotUnique && size > 1) {
            throw new BuildException("Pattern '" + pattern + "' cannot be resolved to a unique node. Matching nodes are: " + map.values());
        }
        return (Node)map.get(map.firstKey());
    }

    public Collection<Node> find(String pattern) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        return map.values();
    }

    public Node addRootNode(MavenProject pom) {
        Artifact artifact = pom.getArtifact();
        return this.getRootNode(artifact);
    }

    public Node addRootNode(String key) {
        ArtifactDescriptor ad = new ArtifactDescriptor(key);
        Artifact artifact = GraphTask.readArtifact(ad);
        return this.getRootNode(artifact);
    }

    public Node getRootNode(Artifact artifact) {
        MavenProject pom = this.resolver.load(artifact);
        Node node = this.nodes.get(artifact);
        if (node == null) {
            node = new Node(this, artifact, pom);
            this.nodes.put(node.getId(), node);
            this.nodesByArtifact.put(artifact, node);
            this.roots.add(node);
        }
        return node;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public Node lookup(String id) {
        return this.nodes.get(id);
    }

    public Node lookup(Artifact artifact) {
        return this.lookup(Node.createNodeId(artifact));
    }

    public Node findNode(ArtifactDescriptor ad) {
        String key = ad.getNodeKeyPattern();
        Collection<Node> nodesToParse = null;
        nodesToParse = key == null ? this.getNodes() : this.find(key);
        Node returnNode = null;
        for (Node node : nodesToParse) {
            Artifact artifact = node.getArtifact();
            if (ad.artifactId != null && !ad.artifactId.equals(artifact.getArtifactId()) || ad.groupId != null && !ad.groupId.equals(artifact.getGroupId()) || ad.version != null && !ad.version.equals(artifact.getVersion()) || ad.type != null && !ad.type.equals(artifact.getType())) continue;
            try {
                if (returnNode != null && artifact.getSelectedVersion().compareTo((Object)returnNode.getArtifact().getSelectedVersion()) < 0) {
                    continue;
                }
            }
            catch (OverConstrainedVersionException e) {
                MavenClientFactory.getLog().error("Versions comparison failed on " + artifact, e);
            }
            returnNode = node;
        }
        return returnNode;
    }

    public MavenProject loadPom(Artifact artifact) {
        if ("system".equals(artifact.getScope())) {
            return null;
        }
        try {
            return this.maven.getProjectBuilder().buildFromRepository(this.maven.getArtifactFactory().createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), this.maven.getRemoteRepositories(), this.maven.getLocalRepository());
        }
        catch (Exception e) {
            MavenClientFactory.getLog().error(e.getMessage(), e);
            return null;
        }
    }

    protected void validateDependencyTree() {
        UnreferencedNodesValidator validator = new UnreferencedNodesValidator();
        validator.process(this);
        if (validator.unreferencedNodes.size() > 0) {
            MavenClientFactory.getLog().warn("Fixed unreferenced nodes : " + validator.unreferencedNodes);
        }
    }

    public void resolveDependencyTree(Node node, Filter filter, int depth) {
        MavenClientFactory.getLog().info("Resolving dependencies");
        NodesInjector injector = new NodesInjector(node, filter, depth);
        try {
            this.maven.resolveDependencyTree(node.artifact, new ArtifactFilter(){

                public boolean include(Artifact artifact) {
                    return false;
                }
            }, injector);
        }
        catch (Exception cause) {
            throw new Error("Cannot resolve dependency tree for " + node, cause);
        }
        this.validateDependencyTree();
        MavenClientFactory.getLog().info("Filtering dependency tree");
        injector.removeFiltered();
        this.validateDependencyTree();
    }

    protected class UnreferencedNodesValidator
    extends AbstractGraphVisitor {
        protected HashSet<Node> unreferencedNodes = new HashSet();

        protected UnreferencedNodesValidator() {
        }

        @Override
        public boolean visitNode(Node node) {
            if (Graph.this.nodes.get(node.id) == null) {
                this.unreferencedNodes.add(node);
                Graph.this.nodes.put(node.id, node);
            }
            return true;
        }

        @Override
        public boolean visitEdge(Edge edge) {
            return true;
        }
    }

    protected class NodesInjector
    implements ResolutionListener {
        protected final HashSet<Node> filteredNodes = new HashSet();
        protected final Stack<Node> parentNodes = new Stack();
        protected final Node rootNode;
        protected final Filter filter;
        protected final int maxDepth;
        protected Node currentNode;
        protected final Logger logger = MavenClientFactory.getLog();

        protected NodesInjector(Node node, Filter filter, int maxDepth) {
            this.currentNode = node;
            this.rootNode = node;
            this.filter = filter;
            this.maxDepth = maxDepth;
            this.rootNode.state = 1;
        }

        public void testArtifact(Artifact node) {
            this.debug("testArtifact: artifact=" + node);
        }

        public void startProcessChildren(Artifact artifact) {
            this.debug("startProcessChildren: artifact=" + artifact);
            if (!this.currentNode.getArtifact().equals(artifact)) {
                throw new IllegalStateException("Artifact was expected to be " + this.currentNode.getArtifact() + " but was " + artifact);
            }
            this.parentNodes.push(this.currentNode);
        }

        public void endProcessChildren(Artifact artifact) {
            Node node = this.parentNodes.pop();
            this.debug("endProcessChildren: artifact=" + artifact);
            if (node == null) {
                throw new IllegalStateException("Parent dependency node was null");
            }
            if (!node.getArtifact().equals(artifact)) {
                throw new IllegalStateException("Parent dependency node artifact was expected to be " + node.getArtifact() + " but was " + artifact);
            }
        }

        public void includeArtifact(Artifact artifact) {
            this.debug("includeArtifact: artifact=" + artifact);
            Node node = Graph.this.nodesByArtifact.get(artifact);
            if (node != null) {
                this.debug("already included, returning : artifact=" + artifact);
                return;
            }
            if (!this.isCurrentNodeIncluded()) {
                this.debug("not included, returning : artifact=" + this.currentNode);
                return;
            }
            this.addNode(artifact);
        }

        public void omitForNearer(Artifact omitted, Artifact kept) {
            this.debug("omitForNearer: omitted=" + omitted + "( " + System.identityHashCode(omitted) + ") kept=" + kept + "(" + System.identityHashCode(kept) + ")");
            if (!omitted.getDependencyConflictId().equals(kept.getDependencyConflictId())) {
                throw new IllegalArgumentException("Omitted artifact dependency conflict id " + omitted.getDependencyConflictId() + " differs from kept artifact dependency conflict id " + kept.getDependencyConflictId());
            }
            if (!this.isCurrentNodeIncluded()) {
                this.debug("not included, returning : artifact=" + this.currentNode);
                return;
            }
            Node keptNode = Graph.this.nodesByArtifact.get(kept);
            if (keptNode == null) {
                keptNode = this.addNode(kept);
            } else {
                this.addEdges(keptNode);
                this.currentNode = keptNode;
            }
        }

        public void updateScope(Artifact artifact, String scope) {
            this.debug("updateScope: artifact=" + artifact + ", scope=" + scope);
        }

        public void manageArtifact(Artifact artifact, Artifact replacement) {
            this.debug("manageArtifact: artifact=" + artifact + ", replacement=" + replacement);
        }

        public void omitForCycle(Artifact artifact) {
            this.warn("omitForCycle: artifact=" + artifact);
        }

        public void updateScopeCurrentPom(Artifact artifact, String ignoredScope) {
            this.debug("updateScopeCurrentPom: artifact=" + artifact + ", scopeIgnored=" + ignoredScope);
        }

        public void selectVersionFromRange(Artifact artifact) {
            this.warn("selectVersionFromRange: artifact=" + artifact);
        }

        public void restrictRange(Artifact artifact, Artifact replacement, VersionRange newRange) {
            this.warn("restrictRange: artifact=" + artifact + ", replacement=" + replacement + ", versionRange=" + newRange);
        }

        protected void debug(String message) {
            if (!this.logger.isDebugEnabled()) {
                return;
            }
            int depth = this.parentNodes.size();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < depth; ++i) {
                buffer.append("  ");
            }
            buffer.append(message);
            this.logger.debug(buffer.toString());
        }

        protected void warn(String message) {
            int depth = this.parentNodes.size();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < depth; ++i) {
                buffer.append("  ");
            }
            buffer.append(message);
            this.logger.info(buffer.toString());
        }

        protected boolean isCurrentNodeIncluded() {
            for (Node node : this.parentNodes) {
                if (node.state == 1 || node.state == 3) continue;
                return false;
            }
            return true;
        }

        protected Node addNode(Artifact artifact) {
            Node node = this.createNode(artifact);
            Node previousNode = Graph.this.nodesByArtifact.put(artifact, node);
            Graph.this.nodes.put(node.id, node);
            if (previousNode != null) {
                throw new IllegalStateException("Duplicate node registered for artifact: " + node.getArtifact());
            }
            this.currentNode = node;
            this.debug("indexed artifact=" + artifact + ",identity=" + System.identityHashCode(artifact));
            return node;
        }

        protected void removeNode(Artifact artifact) {
            Node node = Graph.this.nodesByArtifact.remove(artifact);
            if (node == null) {
                this.warn("removing not indexed " + System.identityHashCode(artifact) + " : artifact=" + artifact);
                node = Graph.this.nodes.get(Node.createNodeId(artifact));
            }
            Graph.this.nodes.remove(node.id);
            if (this.filteredNodes.remove(node)) {
                this.debug("Reset filtering : " + node);
            }
            for (Edge e : node.edgesOut) {
                e.out.edgesIn.remove(e);
            }
            for (Edge e : node.edgesIn) {
                e.in.edgesOut.remove(e);
            }
            if (!artifact.equals(node.getArtifact())) {
                throw new IllegalStateException("Removed dependency node artifact was expected to be " + artifact + " but was " + node.getArtifact());
            }
            this.debug("unindexed   artifact=" + artifact + ",identity= " + System.identityHashCode(artifact));
        }

        protected Node createNode(Artifact artifact) {
            MavenProject pom = Graph.this.resolver.load(artifact);
            Node node = new Node(Graph.this, artifact, pom);
            this.addEdges(node);
            return node;
        }

        protected void addEdges(Node out) {
            if (this.parentNodes.isEmpty()) {
                return;
            }
            Node in = this.parentNodes.peek();
            Edge edge = new Edge(in, out);
            switch (out.state) {
                case 0: {
                    if (!this.accept(edge)) {
                        this.filteredNodes.add(out);
                        out.state = 3;
                        return;
                    }
                    out.state = 1;
                    break;
                }
                case 3: {
                    if (!this.accept(edge)) break;
                    this.filteredNodes.remove(out);
                    this.warn("unfiltering : artifact=" + out.artifact);
                    out.state = 1;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot add edge : artifact=" + out.artifact);
                }
            }
            out.edgesIn.add(edge);
            in.edgesOut.add(edge);
        }

        protected boolean accept(Edge edge) {
            if (edge.in.state == 3) {
                this.debug("filtering edge (inherited from parent) : artifact=" + edge.out);
                return false;
            }
            if (this.parentNodes.size() >= this.maxDepth) {
                this.debug("filtering edge (max depth) : artifact=" + edge.out);
                return false;
            }
            if (!this.filter.accept(edge)) {
                this.debug("filtering edge (filter) : artifact=" + edge.out.artifact);
                return false;
            }
            return true;
        }

        protected void removeFiltered() {
            Iterator<Node> it = this.filteredNodes.iterator();
            while (it.hasNext()) {
                Node n = it.next();
                it.remove();
                this.removeNode(n.artifact);
            }
        }
    }
}

