/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;

public class Node {
    protected final Graph graph;
    protected final String id;
    protected final Artifact artifact;
    protected final List<Edge> edgesIn = new ArrayList<Edge>();
    protected final List<Edge> edgesOut = new ArrayList<Edge>();
    protected final MavenProject pom;
    private List<char[]> acceptedCategories;
    protected static final int UNKNOWN = 0;
    protected static final int INCLUDED = 1;
    protected static final int OMITTED = 2;
    protected static final int FILTERED = 3;
    protected int state = 0;

    public List<char[]> getAcceptedCategories() {
        if (this.acceptedCategories == null) {
            this.acceptedCategories = new ArrayList<char[]>();
        }
        return this.acceptedCategories;
    }

    public static String createNodeId(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion() + ':' + artifact.getType() + ':';
    }

    public Node(Node node) {
        this.id = node.id;
        this.graph = node.graph;
        this.artifact = node.artifact;
        this.edgesIn.addAll(node.edgesIn);
        this.edgesOut.addAll(node.edgesOut);
        this.pom = node.pom;
    }

    protected Node(Graph graph, Artifact artifact, MavenProject pom) {
        this.id = Node.createNodeId(artifact);
        this.graph = graph;
        this.artifact = artifact;
        this.pom = pom;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public File getFile() {
        File file;
        if (!this.artifact.isResolved()) {
            this.graph.getResolver().resolve(this.artifact);
        }
        if ((file = this.artifact.getFile()) != null) {
            this.graph.file2artifacts.put(file.getName(), this.artifact);
        }
        return file;
    }

    public File getFile(String classifier) {
        Artifact ca = this.graph.maven.getArtifactFactory().createArtifactWithClassifier(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getVersion(), this.artifact.getType(), classifier);
        try {
            this.graph.maven.resolve(ca);
            File file = ca.getFile();
            if (file != null) {
                this.graph.file2artifacts.put(file.getAbsolutePath(), ca);
            }
            return file;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean isRoot() {
        return this.edgesIn.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public Collection<Edge> getEdgesOut() {
        return this.edgesOut;
    }

    public Collection<Edge> getEdgesIn() {
        return this.edgesIn;
    }

    protected void addEdgeIn(Edge edge) {
        this.edgesIn.add(edge);
    }

    protected void addEdgeOut(Edge edge) {
        this.edgesOut.add(edge);
    }

    public MavenProject getPom() {
        return this.pom;
    }

    public MavenProject getPomIfAlreadyLoaded() {
        return this.pom;
    }

    public List<Node> getTrail() {
        if (this.edgesIn.isEmpty()) {
            ArrayList<Node> result = new ArrayList<Node>();
            result.add(this);
            return result;
        }
        Edge edge = this.edgesIn.get(0);
        List<Node> path = edge.in.getTrail();
        path.add(this);
        return path;
    }

    public void collectNodes(Collection<Node> nodes, Filter filter) {
        for (Edge edge : this.edgesOut) {
            if (!filter.accept(edge)) continue;
            nodes.add(edge.out);
        }
    }

    public void collectNodes(Collection<Node> nodes) {
        for (Edge edge : this.edgesOut) {
            nodes.add(edge.out);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Node) {
            return ((Node)obj).id.equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    public void setAcceptedCategory(char[] pattern) {
        this.getAcceptedCategories().add(pattern);
    }

    public boolean isAcceptedCategory(List<char[]> patterns) {
        for (char[] pattern : patterns) {
            if (!this.getAcceptedCategories().contains(pattern)) continue;
            return true;
        }
        return false;
    }

    public void expand(Filter filter, int depth) {
        this.graph.resolveDependencyTree(this, filter, depth);
    }
}

