/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;

public final class FileUtils {
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 8192;

    private FileUtils() {
    }

    public static void safeClose(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] createBuffer(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 65536;
        }
        if (preferredSize > 0x100000) {
            preferredSize = 0x100000;
        } else if (preferredSize < 8192) {
            preferredSize = 8192;
        }
        return new byte[preferredSize];
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = FileUtils.createBuffer(in.available());
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] buffer = FileUtils.createBuffer(in.available());
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, read));
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }

    public static byte[] readBytes(URL url) throws IOException {
        return FileUtils.readBytes(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException {
        byte[] buffer = FileUtils.createBuffer(in.available());
        int w = 0;
        try {
            int len;
            int read = 0;
            do {
                if ((len = buffer.length - (w += read)) > 0) continue;
                byte[] b = new byte[buffer.length + 65536];
                System.arraycopy(buffer, 0, b, 0, w);
                buffer = b;
                len = buffer.length - w;
            } while ((read = in.read(buffer, w, len)) != -1);
        }
        finally {
            in.close();
        }
        if (buffer.length > w) {
            byte[] b = new byte[w];
            System.arraycopy(buffer, 0, b, 0, w);
            buffer = b;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String string = FileUtils.read(in);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream in = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, List<String> lines) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileOutputStream(file));
            for (String line : lines) {
                out.println(line);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] byArray = FileUtils.readBytes(in);
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] buf) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(buf);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void writeFile(File file, String buf) throws IOException {
        FileUtils.writeFile(file, buf.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(URL url, File file) throws IOException {
        InputStream in = url.openStream();
        FileOutputStream out = new FileOutputStream(file);
        try {
            FileUtils.copy(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            ((OutputStream)out).close();
        }
    }

    public static void deleteTree(File dir) {
        FileUtils.emptyDirectory(dir);
        dir.delete();
    }

    public static void emptyDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileUtils.deleteTree(file);
                continue;
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(InputStream in, File file) throws IOException {
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(file);
            byte[] buffer = FileUtils.createBuffer(in.available());
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL url, File file) throws IOException {
        InputStream in = url.openStream();
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static void append(File src, File dst) throws IOException {
        FileUtils.append(src, dst, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(File src, File dst, boolean appendNewLine) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(src);
            FileUtils.append(in, dst, appendNewLine);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public static void append(InputStream in, File file) throws IOException {
        FileUtils.append(in, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(InputStream in, File file, boolean appendNewLine) throws IOException {
        OutputStream out = null;
        try {
            int read;
            out = new BufferedOutputStream(new FileOutputStream(file, true));
            if (appendNewLine) {
                out.write(System.getProperty("line.separator").getBytes());
            }
            byte[] buffer = new byte[65536];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.equals(dst)) {
            return;
        }
        if (src.isFile()) {
            FileUtils.copyFile(src, dst);
        } else {
            FileUtils.copyTree(src, dst);
        }
    }

    public static void copy(File[] src, File dst) throws IOException {
        for (File file : src) {
            FileUtils.copy(file, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        FileInputStream in = null;
        FileOutputStream out = new FileOutputStream(dst);
        try {
            in = new FileInputStream(src);
            FileUtils.copy(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            out.close();
        }
    }

    public static void copyTree(File src, File dst) throws IOException {
        if (src.isFile()) {
            FileUtils.copyFile(src, dst);
        } else if (src.isDirectory()) {
            File[] files;
            if (dst.exists()) {
                dst = new File(dst, src.getName());
                dst.mkdir();
            } else {
                dst.mkdirs();
            }
            for (File file : files = src.listFiles()) {
                FileUtils.copyTree(file, dst);
            }
        }
    }

    public static String getFilePathFromUrl(URL url) {
        String path = "";
        if (url.getProtocol().equals("file")) {
            try {
                path = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public static File getFileFromURL(URL url) {
        String filename = FileUtils.getFilePathFromUrl(url);
        File file = filename.equals("") ? null : new File(filename);
        return file;
    }

    public static String getParentPath(String path) {
        int p = path.lastIndexOf(47);
        if (p == -1) {
            return null;
        }
        return path.substring(0, p);
    }

    public static String getFileName(String path) {
        int p = path.lastIndexOf(47);
        if (p == -1) {
            return path;
        }
        return path.substring(p + 1);
    }

    public static String getFileExtension(String path) {
        int p = path.lastIndexOf(46);
        if (p == -1) {
            return null;
        }
        return path.substring(p + 1);
    }

    public static String getFileNameNoExt(String path) {
        String name = FileUtils.getFileName(path);
        int p = name.lastIndexOf(46);
        if (p == -1) {
            return name;
        }
        return name.substring(0, p);
    }

    public static String getResourcePathFromContext(String resource) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        return FileUtils.getFilePathFromUrl(url);
    }

    public static File getResourceFileFromContext(String resource) {
        String filename = FileUtils.getResourcePathFromContext(resource);
        File file = filename.equals("") ? null : new File(filename);
        return file;
    }

    public static void collectFiles(File root, List<File> result) {
        File[] files;
        for (File file : files = root.listFiles()) {
            result.add(file);
            if (!file.isDirectory()) continue;
            FileUtils.collectFiles(root, result);
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File urlToFile(String url) throws MalformedURLException {
        return FileUtils.urlToFile(new URL(url));
    }

    public static File urlToFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(InputStream in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }
}

