/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.Node;

public class AttachArtifactTask
extends Task {
    private File file;
    private String classifier;
    private String type;
    private String targetArtifact;

    public void setFile(File file) {
        this.file = file;
    }

    public void setClassifier(String classifier) {
        this.classifier = "".equals(classifier) ? null : classifier;
    }

    public void setTarget(String artifactKey) {
        this.targetArtifact = artifactKey;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void execute() throws BuildException {
        MavenClient maven = MavenClientFactory.getInstance();
        if (this.targetArtifact == null) {
            throw new BuildException("Target artifact not set");
        }
        Node node = maven.getGraph().findFirst(this.targetArtifact, true);
        if (node == null) {
            throw new BuildException("No such artifact found: " + this.targetArtifact);
        }
        this.log("Attaching " + this.file + " to " + this.targetArtifact, 2);
        if (this.type == null) {
            this.type = this.getExtension(this.file.getName());
            this.log("Unspecified type, guessing is: " + this.type, 1);
        }
        if (this.classifier != null) {
            maven.getProjectHelper().attachArtifact(node.getPom(), this.type, this.classifier, this.file);
        } else {
            node.getPom().getArtifact().setFile(this.file);
            node.getPom().getArtifact().setResolved(true);
        }
    }

    private String getExtension(String name) {
        int idx = name.lastIndexOf(46);
        return name.substring(idx + 1);
    }
}

