/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.ant.artifact.NuxeoExpandTask;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class PrintGraphTask
extends Task {
    public static final String MODE_TREE = "tree";
    public static final String MODE_FLAT = "flat";
    public static final String MODE_SDK = "sdk";
    private OutputStream output = System.out;
    private String mode = "tree";
    private int format = 0;
    private boolean append = false;
    private String source;
    private List<String> scopes = Arrays.asList("compile", "runtime", "system");

    public void execute() throws BuildException {
        if (this.source != null) {
            ArtifactDescriptor ad = new ArtifactDescriptor(this.source);
            Artifact artifact = ad.getArtifact();
            try {
                MavenClientFactory.getInstance().resolve(artifact);
            }
            catch (ArtifactNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
            Graph graph = MavenClientFactory.getInstance().newGraph();
            graph.getRootNode(artifact);
            NuxeoExpandTask expandTask = new NuxeoExpandTask();
            expandTask.setDepth("all");
            expandTask.execute(graph);
        }
        for (Node node : MavenClientFactory.getInstance().getGraph().getRoots()) {
            try {
                HashSet<Node> collectedNodes = new HashSet<Node>();
                if (MODE_TREE.equalsIgnoreCase(this.mode)) {
                    this.printTree("", node, collectedNodes);
                    continue;
                }
                if (MODE_FLAT.equalsIgnoreCase(this.mode)) {
                    HashSet<String> printedArtifacts = new HashSet<String>();
                    printedArtifacts.add(node.getId());
                    for (Edge edge : node.getEdgesOut()) {
                        this.printFlat(edge.out, collectedNodes, printedArtifacts);
                    }
                    continue;
                }
                throw new BuildException("Unknown mode: " + this.mode);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void printFlat(Node node, HashSet<Node> collectedNodes, HashSet<String> printedArtifacts) throws IOException {
        if (this.scopes.contains(node.getArtifact().getScope()) && !printedArtifacts.contains(node.getId())) {
            this.print(node.toString(this.format) + System.getProperty("line.separator"));
            printedArtifacts.add(node.getId());
        }
        if (!collectedNodes.add(node)) {
            return;
        }
        for (Edge edge : node.getEdgesOut()) {
            this.printFlat(edge.out, collectedNodes, printedArtifacts);
        }
    }

    private void printTree(String tabs, Node node, Set<Node> collectedNodes) throws IOException {
        this.print(tabs + node.toString(this.format) + System.getProperty("line.separator"));
        if (collectedNodes.contains(node)) {
            return;
        }
        collectedNodes.add(node);
        for (Edge edge : node.getEdgesOut()) {
            this.printTree(tabs + " |-- ", edge.out, collectedNodes);
        }
    }

    public void setOutput(String output) throws FileNotFoundException {
        this.output = new FileOutputStream(output, this.append);
    }

    private void print(String message) throws IOException {
        this.output.write(message.getBytes());
    }

    public void setMode(String mode) {
        if (MODE_SDK.equals(mode)) {
            this.mode = MODE_FLAT;
            this.format = 1;
        } else {
            this.mode = mode;
        }
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setScopes(String scopes) {
        StringTokenizer st = new StringTokenizer(scopes, ",");
        this.scopes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            this.scopes.add(st.nextToken());
        }
    }
}

