/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClientFactory;

public class ResolveFiles
extends DataType
implements ResourceCollection {
    private Properties source;
    private String classifier;
    private List<FileResource> artifacts;

    public void setSource(String source) throws FileNotFoundException, IOException {
        File[] files;
        this.source = new Properties();
        File sourceFile = new File(source);
        for (File file : files = sourceFile.getParentFile().listFiles((FileFilter)new WildcardFileFilter(sourceFile.getName()))) {
            MavenClientFactory.getLog().debug("Loading " + file);
            this.source.load(new FileInputStream(file));
        }
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    public Iterator<FileResource> iterator() {
        if (this.isReference()) {
            return ((ResourceCollection)this.getCheckedRef()).iterator();
        }
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<FileResource>();
            for (String string : this.source.values()) {
                try {
                    this.artifacts.add(this.resolveFile(string));
                }
                catch (ArtifactNotFoundException e) {
                    MavenClientFactory.getLog().warn(e.getMessage());
                }
            }
        }
        return this.artifacts.iterator();
    }

    private FileResource resolveFile(String artifactKey) throws ArtifactNotFoundException {
        ArtifactDescriptor ad = new ArtifactDescriptor(artifactKey);
        if (this.classifier != null) {
            ad.classifier = this.classifier;
        }
        Artifact artifact = ad.getArtifact();
        MavenClientFactory.getInstance().resolve(artifact);
        FileResource fr = new FileResource(artifact.getFile());
        fr.setBaseDir(artifact.getFile().getParentFile());
        return fr;
    }

    public int size() {
        return this.artifacts.size();
    }
}

