/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.antcontrib.antserver.Command;
import net.sf.antcontrib.antserver.Response;
import net.sf.antcontrib.antserver.client.Client;
import net.sf.antcontrib.antserver.commands.RunAntCommand;
import net.sf.antcontrib.antserver.commands.RunTargetCommand;
import net.sf.antcontrib.antserver.commands.SendFileCommand;
import net.sf.antcontrib.antserver.commands.ShutdownCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClientTask
extends Task {
    private String machine = "localhost";
    private int port = 17000;
    private Vector commands = new Vector();
    private boolean persistant = false;
    private boolean failOnError = true;

    public void setMachine(String machine) {
        this.machine = machine;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPersistant(boolean persistant) {
        this.persistant = persistant;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void addConfiguredShutdown(ShutdownCommand cmd) {
        this.commands.add(cmd);
    }

    public void addConfiguredRunTarget(RunTargetCommand cmd) {
        this.commands.add(cmd);
    }

    public void addConfiguredRunAnt(RunAntCommand cmd) {
        this.commands.add(cmd);
    }

    public void addConfiguredSendFile(SendFileCommand cmd) {
        this.commands.add(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Enumeration e = this.commands.elements();
        Command c = null;
        while (e.hasMoreElements()) {
            c = (Command)e.nextElement();
            c.validate(this.getProject());
        }
        Client client = new Client(this.getProject(), this.machine, this.port);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                int failCount = 0;
                client.connect();
                e = this.commands.elements();
                c = null;
                Response r = null;
                Document d = null;
                boolean keepGoing = true;
                while (e.hasMoreElements() && keepGoing) {
                    c = (Command)e.nextElement();
                    r = client.sendCommand(c);
                    if (!r.isSucceeded()) {
                        ++failCount;
                        this.log("Command caused a build failure:" + c, 0);
                        this.log(r.getErrorMessage(), 0);
                        this.log(r.getErrorStackTrace(), 4);
                        if (!this.persistant) {
                            keepGoing = false;
                        }
                    }
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(r.getResultsXml().getBytes());
                        d = db.parse(bais);
                        NodeList nl = d.getElementsByTagName("target");
                        int len = nl.getLength();
                        Element element = null;
                        for (int i = 0; i < len; ++i) {
                            element = (Element)nl.item(i);
                            this.getProject().log("[" + element.getAttribute("name") + "]", 2);
                        }
                    }
                    catch (SAXException se) {
                        // empty catch block
                    }
                    if (!(c instanceof ShutdownCommand)) continue;
                    keepGoing = false;
                    client.shutdown();
                }
                if (failCount > 0 && this.failOnError) {
                    throw new BuildException("One or more commands failed.");
                }
            }
            finally {
                if (client != null) {
                    client.disconnect();
                }
            }
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException(ex);
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
    }
}

