/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.sf.antcontrib.antserver.server.ConnectionHandler;
import net.sf.antcontrib.antserver.server.ServerTask;
import org.apache.tools.ant.BuildException;

public class Server
implements Runnable {
    private ServerTask task;
    private int port = 17000;
    private boolean running = false;
    private Thread thread = null;

    public Server(ServerTask task, int port) {
        this.task = task;
        this.port = port;
    }

    public void start() throws InterruptedException {
        this.thread = new Thread(this);
        this.thread.start();
        this.thread.join();
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServerSocket server = null;
        this.running = true;
        try {
            this.task.getProject().log("Starting server on port: " + this.port, 4);
            try {
                server = new ServerSocket(this.port);
                server.setSoTimeout(500);
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
            while (this.running) {
                try {
                    Socket clientSocket = server.accept();
                    this.task.getProject().log("Got a client connection. Starting Handler.", 4);
                    ConnectionHandler handler = new ConnectionHandler(this.task, clientSocket);
                    handler.start();
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    this.task.getProject().log(e.getMessage(), 0);
                }
            }
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                    server = null;
                }
                catch (IOException iOException) {}
            }
        }
        this.running = false;
    }
}

