/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.antcontrib.util.ThreadPool;
import net.sf.antcontrib.util.ThreadPoolThread;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;

public class ForEach
extends Task {
    private String list = null;
    private String param = null;
    private String delimiter = ",";
    private String target = null;
    private boolean inheritAll = false;
    private boolean inheritRefs = false;
    private Vector params = new Vector();
    private Vector references = new Vector();
    private Path currPath;
    private boolean parallel = false;
    private boolean trim;
    private int maxThreads = 5;
    private Mapper mapper;

    private void executeParallel(Vector tasks) {
        ThreadPool pool = new ThreadPool(this.maxThreads);
        Enumeration e = tasks.elements();
        Runnable r = null;
        Vector<ThreadPoolThread> threads = new Vector<ThreadPoolThread>();
        while (e.hasMoreElements()) {
            final Task task = (Task)e.nextElement();
            r = new Runnable(){

                public void run() {
                    task.execute();
                }
            };
            try {
                ThreadPoolThread tpt = pool.borrowThread();
                tpt.setRunnable(r);
                tpt.start();
                threads.addElement(tpt);
            }
            catch (Exception ex) {
                throw new BuildException(ex);
            }
        }
        Enumeration te = threads.elements();
        Thread t = null;
        while (te.hasMoreElements()) {
            t = (Thread)te.nextElement();
            if (!t.isAlive()) continue;
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                throw new BuildException(ex);
            }
        }
    }

    private void executeSequential(Vector tasks) {
        TaskContainer tc = (TaskContainer)((Object)this.getProject().createTask("sequential"));
        Enumeration e = tasks.elements();
        Task t = null;
        while (e.hasMoreElements()) {
            t = (Task)e.nextElement();
            tc.addTask(t);
        }
        ((Task)((Object)tc)).execute();
    }

    public void execute() throws BuildException {
        if (this.list == null && this.currPath == null) {
            throw new BuildException("You must have a list or path to iterate through");
        }
        if (this.param == null) {
            throw new BuildException("You must supply a property name to set on each iteration in param");
        }
        if (this.target == null) {
            throw new BuildException("You must supply a target to perform");
        }
        Vector<Object> values = new Vector<Object>();
        if (this.list != null) {
            StringTokenizer st = new StringTokenizer(this.list, this.delimiter);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (this.trim) {
                    tok = tok.trim();
                }
                values.addElement(tok);
            }
        }
        String[] pathElements = new String[]{};
        if (this.currPath != null) {
            pathElements = this.currPath.list();
        }
        for (int i = 0; i < pathElements.length; ++i) {
            if (this.mapper != null) {
                FileNameMapper m = this.mapper.getImplementation();
                String[] mapped = m.mapFileName(pathElements[i]);
                for (int j = 0; j < mapped.length; ++j) {
                    values.addElement(mapped[j]);
                }
                continue;
            }
            values.addElement(new File(pathElements[i]));
        }
        Vector<CallTarget> tasks = new Vector<CallTarget>();
        int sz = values.size();
        CallTarget ct = null;
        Object val = null;
        Property p = null;
        for (int i = 0; i < sz; ++i) {
            val = values.elementAt(i);
            ct = this.createCallTarget();
            p = ct.createParam();
            p.setName(this.param);
            if (val instanceof File) {
                p.setLocation((File)val);
            } else {
                p.setValue((String)val);
            }
            tasks.addElement(ct);
        }
        if (this.parallel && this.maxThreads > 1) {
            this.executeParallel(tasks);
        } else {
            this.executeSequential(tasks);
        }
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public void setList(String list) {
        this.list = list;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setInheritall(boolean b) {
        this.inheritAll = b;
    }

    public void setInheritrefs(boolean b) {
        this.inheritRefs = b;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void addParam(Property p) {
        this.params.addElement(p);
    }

    public void addReference(Ant.Reference r) {
        this.references.addElement(r);
    }

    public void addFileset(FileSet set) {
        this.log("The nested fileset element is deprectated, use a nested path instead", 1);
        this.createPath().addFileset(set);
    }

    public Path createPath() {
        if (this.currPath == null) {
            this.currPath = new Path(this.getProject());
        }
        return this.currPath;
    }

    public Mapper createMapper() {
        this.mapper = new Mapper(this.getProject());
        return this.mapper;
    }

    private CallTarget createCallTarget() {
        CallTarget ct = (CallTarget)this.getProject().createTask("antcall");
        ct.setOwningTarget(this.getOwningTarget());
        ct.init();
        ct.setTarget(this.target);
        ct.setInheritAll(this.inheritAll);
        ct.setInheritRefs(this.inheritRefs);
        Enumeration e = this.params.elements();
        while (e.hasMoreElements()) {
            Property param = (Property)e.nextElement();
            Property toSet = ct.createParam();
            toSet.setName(param.getName());
            if (param.getValue() != null) {
                toSet.setValue(param.getValue());
            }
            if (param.getFile() != null) {
                toSet.setFile(param.getFile());
            }
            if (param.getResource() != null) {
                toSet.setResource(param.getResource());
            }
            if (param.getPrefix() != null) {
                toSet.setPrefix(param.getPrefix());
            }
            if (param.getRefid() != null) {
                toSet.setRefid(param.getRefid());
            }
            if (param.getEnvironment() != null) {
                toSet.setEnvironment(param.getEnvironment());
            }
            if (param.getClasspath() == null) continue;
            toSet.setClasspath(param.getClasspath());
        }
        e = this.references.elements();
        while (e.hasMoreElements()) {
            ct.addReference((Ant.Reference)e.nextElement());
        }
        return ct;
    }

    protected void handleOutput(String line) {
        try {
            super.handleOutput(line);
        }
        catch (IllegalAccessError e) {
            super.handleOutput(line);
        }
    }

    protected void handleErrorOutput(String line) {
        try {
            super.handleErrorOutput(line);
        }
        catch (IllegalAccessError e) {
            super.handleErrorOutput(line);
        }
    }
}

