/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Sequential;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.taskdefs.condition.ConditionBase;

public class IfTask
extends ConditionBase {
    private Sequential thenTasks = null;
    private Vector elseIfTasks = new Vector();
    private Sequential elseTasks = null;

    public void addElseIf(ElseIf ei) {
        this.elseIfTasks.addElement(ei);
    }

    public void addThen(Sequential t) {
        if (this.thenTasks != null) {
            throw new BuildException("You must not nest more than one <then> into <if>");
        }
        this.thenTasks = t;
    }

    public void addElse(Sequential e) {
        if (this.elseTasks != null) {
            throw new BuildException("You must not nest more than one <else> into <if>");
        }
        this.elseTasks = e;
    }

    public void execute() throws BuildException {
        if (this.countConditions() > 1) {
            throw new BuildException("You must not nest more than one condition into <if>");
        }
        if (this.countConditions() < 1) {
            throw new BuildException("You must nest a condition into <if>");
        }
        Condition c = (Condition)this.getConditions().nextElement();
        if (c.eval()) {
            if (this.thenTasks != null) {
                this.thenTasks.execute();
            }
        } else {
            boolean done = false;
            int sz = this.elseIfTasks.size();
            for (int i = 0; i < sz && !done; ++i) {
                ElseIf ei = (ElseIf)this.elseIfTasks.elementAt(i);
                if (!ei.eval()) continue;
                done = true;
                ei.execute();
            }
            if (!done && this.elseTasks != null) {
                this.elseTasks.execute();
            }
        }
    }

    public static final class ElseIf
    extends ConditionBase {
        private Sequential thenTasks = null;

        public void addThen(Sequential t) {
            if (this.thenTasks != null) {
                throw new BuildException("You must not nest more than one <then> into <elseif>");
            }
            this.thenTasks = t;
        }

        public boolean eval() throws BuildException {
            if (this.countConditions() > 1) {
                throw new BuildException("You must not nest more than one condition into <elseif>");
            }
            if (this.countConditions() < 1) {
                throw new BuildException("You must nest a condition into <elseif>");
            }
            Condition c = (Condition)this.getConditions().nextElement();
            return c.eval();
        }

        public void execute() throws BuildException {
            if (this.thenTasks != null) {
                this.thenTasks.execute();
            }
        }
    }
}

