/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net.httpclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.antcontrib.net.httpclient.AbstractMethodTask;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class PostMethodTask
extends AbstractMethodTask {
    private List parts = new ArrayList();
    private boolean multipart;
    private transient FileInputStream stream;

    public void addConfiguredFile(FilePartType file) {
        this.parts.add(file);
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public void addConfiguredText(TextPartType text) {
        this.parts.add(text);
    }

    public void setParameters(File parameters) {
        PostMethod post = this.getPostMethod();
        Properties p = new Properties();
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            post.addParameter(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    protected HttpMethodBase createNewMethod() {
        return new PostMethod();
    }

    private PostMethod getPostMethod() {
        return (PostMethod)this.createMethodIfNecessary();
    }

    public void addConfiguredParameter(NameValuePair pair) {
        this.getPostMethod().setParameter(pair.getName(), pair.getValue());
    }

    public void setContentChunked(boolean contentChunked) {
        this.getPostMethod().setContentChunked(contentChunked);
    }

    protected void configureMethod(HttpMethodBase method) {
        PostMethod post = (PostMethod)method;
        if (this.parts.size() == 1 && !this.multipart) {
            Object part = this.parts.get(0);
            if (part instanceof FilePartType) {
                FilePartType filePart = (FilePartType)part;
                try {
                    this.stream = new FileInputStream(filePart.getPath().getAbsolutePath());
                    post.setRequestEntity(new InputStreamRequestEntity(this.stream, filePart.getPath().length(), filePart.getContentType()));
                }
                catch (IOException e) {
                    throw new BuildException(e);
                }
            } else if (part instanceof TextPartType) {
                TextPartType textPart = (TextPartType)part;
                try {
                    post.setRequestEntity(new StringRequestEntity(textPart.getValue(), textPart.getContentType(), textPart.getCharSet()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new BuildException(e);
                }
            }
        } else if (!this.parts.isEmpty()) {
            Part[] partArray = new Part[this.parts.size()];
            for (int i = 0; i < this.parts.size(); ++i) {
                Object part = this.parts.get(i);
                if (part instanceof FilePartType) {
                    FilePartType filePart = (FilePartType)part;
                    try {
                        partArray[i] = new FilePart(filePart.getPath().getName(), filePart.getPath().getName(), filePart.getPath(), filePart.getContentType(), filePart.getCharSet());
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new BuildException(e);
                    }
                }
                if (!(part instanceof TextPartType)) continue;
                TextPartType textPart = (TextPartType)part;
                partArray[i] = new StringPart(textPart.getName(), textPart.getValue(), textPart.getCharSet());
                ((StringPart)partArray[i]).setContentType(textPart.getContentType());
            }
            MultipartRequestEntity entity = new MultipartRequestEntity(partArray, post.getParams());
            post.setRequestEntity(entity);
        }
    }

    protected void cleanupResources(HttpMethodBase method) {
        FileUtils.close(this.stream);
    }

    public static class TextPartType {
        private String name = "";
        private String value = "";
        private String charSet = "US-ASCII";
        private String contentType = "text/plain";

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCharSet() {
            return this.charSet;
        }

        public void setCharSet(String charSet) {
            this.charSet = charSet;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setText(String text) {
            this.value = text;
        }
    }

    public static class FilePartType {
        private File path;
        private String contentType = "application/octet-stream";
        private String charSet = "ISO-8859-1";

        public File getPath() {
            return this.path;
        }

        public void setPath(File path) {
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getCharSet() {
            return this.charSet;
        }

        public void setCharSet(String charSet) {
            this.charSet = charSet;
        }
    }
}

