/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.selectors.OrSelector;

public class PathFilterTask
extends Task {
    private OrSelector select;
    private Path path;
    private String pathid;

    public void setPathId(String pathid) {
        this.pathid = pathid;
    }

    public OrSelector createSelect() {
        this.select = new OrSelector();
        return this.select;
    }

    public void addConfiguredFileSet(FileSet fileset) {
        if (this.path == null) {
            this.path = (Path)this.getProject().createDataType("path");
        }
        this.path.addFileset(fileset);
    }

    public void addConfiguredDirSet(DirSet dirset) {
        if (this.path == null) {
            this.path = (Path)this.getProject().createDataType("path");
        }
        this.path.addDirset(dirset);
    }

    public void addConfiguredFileList(FileList filelist) {
        if (this.path == null) {
            this.path = (Path)this.getProject().createDataType("path");
        }
        this.path.addFilelist(filelist);
    }

    public void addConfiguredPath(Path path) {
        if (this.path == null) {
            this.path = (Path)this.getProject().createDataType("path");
        }
        this.path.add(path);
    }

    public void execute() throws BuildException {
        if (this.select == null) {
            throw new BuildException("A <select> element must be specified.");
        }
        if (this.pathid == null) {
            throw new BuildException("A 'pathid' attribute must be specified.");
        }
        Path selectedFiles = (Path)this.getProject().createDataType("path");
        if (this.path != null) {
            String[] files = this.path.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(files[i]);
                if (!this.select.isSelected(file.getParentFile(), file.getName(), file)) continue;
                selectedFiles.createPathElement().setLocation(file);
            }
            this.getProject().addReference(this.pathid, selectedFiles);
        }
    }
}

