/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.jackrabbit.commons.xml.SerializingContentHandler;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.Subscription;
import org.apache.jackrabbit.webdav.observation.SubscriptionDiscovery;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebdavResponseImpl
implements WebdavResponse {
    private static Logger log = LoggerFactory.getLogger(WebdavResponseImpl.class);
    private HttpServletResponse httpResponse;

    public WebdavResponseImpl(HttpServletResponse httpResponse) {
        this(httpResponse, false);
    }

    public WebdavResponseImpl(HttpServletResponse httpResponse, boolean noCache) {
        this.httpResponse = httpResponse;
        if (noCache) {
            this.addHeader("Pragma", "No-cache");
            this.addHeader("Cache-Control", "no-cache");
        }
    }

    public void sendError(DavException exception) throws IOException {
        if (!exception.hasErrorCondition()) {
            this.httpResponse.sendError(exception.getErrorCode(), exception.getStatusPhrase());
        } else {
            this.sendXmlResponse(exception, exception.getErrorCode());
        }
    }

    public void sendMultiStatus(MultiStatus multistatus) throws IOException {
        this.sendXmlResponse(multistatus, 207);
    }

    public void sendLockResponse(ActiveLock lock) throws IOException {
        CodedUrlHeader ltHeader = new CodedUrlHeader("Lock-Token", lock.getToken());
        this.httpResponse.setHeader(ltHeader.getHeaderName(), ltHeader.getHeaderValue());
        DavPropertySet propSet = new DavPropertySet();
        propSet.add(new LockDiscovery(lock));
        this.sendXmlResponse(propSet, 200);
    }

    public void sendRefreshLockResponse(ActiveLock[] locks) throws IOException {
        DavPropertySet propSet = new DavPropertySet();
        propSet.add(new LockDiscovery(locks));
        this.sendXmlResponse(propSet, 200);
    }

    public void sendXmlResponse(XmlSerializable serializable, int status) throws IOException {
        this.httpResponse.setStatus(status);
        if (serializable != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                Document doc = DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument();
                doc.appendChild(serializable.toXml(doc));
                DefaultHandler handler = SerializingContentHandler.getSerializer(out);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.transform(new DOMSource(doc), new SAXResult(handler));
                this.httpResponse.setContentType("text/xml; charset=UTF-8");
                this.httpResponse.setContentLength(out.size());
                out.writeTo((OutputStream)this.httpResponse.getOutputStream());
            }
            catch (ParserConfigurationException e) {
                log.error(e.getMessage());
                throw new IOException(e.getMessage());
            }
            catch (TransformerException e) {
                log.error(e.getMessage());
                throw new IOException(e.getMessage());
            }
            catch (SAXException e) {
                log.error(e.getMessage());
                throw new IOException(e.getMessage());
            }
        }
    }

    public void sendSubscriptionResponse(Subscription subscription) throws IOException {
        String id = subscription.getSubscriptionId();
        if (id != null) {
            CodedUrlHeader h = new CodedUrlHeader("SubscriptionId", id);
            this.httpResponse.setHeader(h.getHeaderName(), h.getHeaderValue());
        }
        DavPropertySet propSet = new DavPropertySet();
        propSet.add(new SubscriptionDiscovery(subscription));
        this.sendXmlResponse(propSet, 200);
    }

    public void sendPollResponse(EventDiscovery eventDiscovery) throws IOException {
        this.sendXmlResponse(eventDiscovery, 200);
    }

    public void addCookie(Cookie cookie) {
        this.httpResponse.addCookie(cookie);
    }

    public boolean containsHeader(String s) {
        return this.httpResponse.containsHeader(s);
    }

    public String encodeURL(String s) {
        return this.httpResponse.encodeRedirectURL(s);
    }

    public String encodeRedirectURL(String s) {
        return this.httpResponse.encodeRedirectURL(s);
    }

    public String encodeUrl(String s) {
        return this.httpResponse.encodeUrl(s);
    }

    public String encodeRedirectUrl(String s) {
        return this.httpResponse.encodeRedirectURL(s);
    }

    public void sendError(int i, String s) throws IOException {
        this.httpResponse.sendError(i, s);
    }

    public void sendError(int i) throws IOException {
        this.httpResponse.sendError(i);
    }

    public void sendRedirect(String s) throws IOException {
        this.httpResponse.sendRedirect(s);
    }

    public void setDateHeader(String s, long l) {
        this.httpResponse.setDateHeader(s, l);
    }

    public void addDateHeader(String s, long l) {
        this.httpResponse.addDateHeader(s, l);
    }

    public void setHeader(String s, String s1) {
        this.httpResponse.setHeader(s, s1);
    }

    public void addHeader(String s, String s1) {
        this.httpResponse.addHeader(s, s1);
    }

    public void setIntHeader(String s, int i) {
        this.httpResponse.setIntHeader(s, i);
    }

    public void addIntHeader(String s, int i) {
        this.httpResponse.addIntHeader(s, i);
    }

    public void setStatus(int i) {
        this.httpResponse.setStatus(i);
    }

    public void setStatus(int i, String s) {
        this.httpResponse.setStatus(i, s);
    }

    public String getCharacterEncoding() {
        return this.httpResponse.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.httpResponse.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.httpResponse.getWriter();
    }

    public void setContentLength(int i) {
        this.httpResponse.setContentLength(i);
    }

    public void setContentType(String s) {
        this.httpResponse.setContentType(s);
    }

    public void setBufferSize(int i) {
        this.httpResponse.setBufferSize(i);
    }

    public int getBufferSize() {
        return this.httpResponse.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.httpResponse.flushBuffer();
    }

    public void resetBuffer() {
        this.httpResponse.resetBuffer();
    }

    public boolean isCommitted() {
        return this.httpResponse.isCommitted();
    }

    public void reset() {
        this.httpResponse.reset();
    }

    public void setLocale(Locale locale) {
        this.httpResponse.setLocale(locale);
    }

    public Locale getLocale() {
        return this.httpResponse.getLocale();
    }
}

