/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.LSParser;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class ScpHelper {
    public static final char PATH_SEPARATOR = '/';
    public static final int DEFAULT_SSH_PORT = 22;
    private final CommandExecutor executor;

    public ScpHelper(CommandExecutor executor) {
        this.executor = executor;
    }

    public static String getResourceDirectory(String resourceName) {
        String dir = PathUtils.dirname(resourceName);
        dir = StringUtils.replace(dir, "\\", "/");
        return dir;
    }

    public static String getResourceFilename(String r) {
        String filename = r.lastIndexOf(47) > 0 ? r.substring(r.lastIndexOf(47) + 1) : r;
        return filename;
    }

    public static Resource getResource(String resourceName) {
        String r = StringUtils.replace(resourceName, "\\", "/");
        return new Resource(r);
    }

    public static File getPrivateKey(AuthenticationInfo authenticationInfo) throws FileNotFoundException {
        File privateKey = null;
        if (authenticationInfo.getPassword() == null) {
            if (authenticationInfo.getPrivateKey() != null) {
                privateKey = new File(authenticationInfo.getPrivateKey());
                if (!privateKey.exists()) {
                    throw new FileNotFoundException("Private key '" + privateKey + "' not found");
                }
            } else {
                privateKey = ScpHelper.findPrivateKey();
            }
            if (privateKey != null && privateKey.exists() && authenticationInfo.getPassphrase() == null) {
                authenticationInfo.setPassphrase("");
            }
        }
        return privateKey;
    }

    private static File findPrivateKey() {
        File privateKey;
        String privateKeyDirectory = System.getProperty("wagon.privateKeyDirectory");
        if (privateKeyDirectory == null) {
            privateKeyDirectory = System.getProperty("user.home");
        }
        if (!(privateKey = new File(privateKeyDirectory, ".ssh/id_dsa")).exists() && !(privateKey = new File(privateKeyDirectory, ".ssh/id_rsa")).exists()) {
            privateKey = null;
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZip(List files, File zipName, File basedir) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipName));
        try {
            for (int i = 0; i < files.size(); ++i) {
                String file = (String)files.get(i);
                file = file.replace('\\', '/');
                ScpHelper.writeZipEntry(zos, new File(basedir, file), file);
            }
        }
        finally {
            IOUtil.close(zos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeZipEntry(ZipOutputStream jar, File source, String entryName) throws IOException {
        byte[] buffer = new byte[1024];
        FileInputStream is = new FileInputStream(source);
        try {
            int bytesRead;
            ZipEntry entry = new ZipEntry(entryName);
            jar.putNextEntry(entry);
            while ((bytesRead = is.read(buffer)) != -1) {
                jar.write(buffer, 0, bytesRead);
            }
        }
        finally {
            is.close();
        }
    }

    protected static String getPath(String basedir, String dir) {
        String path = basedir;
        if (!basedir.endsWith("/") && !dir.startsWith("/")) {
            path = path + "/";
        }
        path = path + dir;
        return path;
    }

    public void putDirectory(Wagon wagon, File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File zipFile;
        Repository repository = wagon.getRepository();
        String basedir = repository.getBasedir();
        String destDir = StringUtils.replace(destinationDirectory, "\\", "/");
        String path = ScpHelper.getPath(basedir, destDir);
        try {
            String dirPerms;
            if (repository.getPermissions() != null && (dirPerms = repository.getPermissions().getDirectoryMode()) != null) {
                String umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor(dirPerms);
                this.executor.executeCommand(umaskCmd);
            }
            String mkdirCmd = "mkdir -p " + path;
            this.executor.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", e);
        }
        try {
            zipFile = File.createTempFile("wagon", ".zip");
            zipFile.deleteOnExit();
            List files = FileUtils.getFileNames(sourceDirectory, "**/**", "", false);
            ScpHelper.createZip(files, zipFile, sourceDirectory);
        }
        catch (IOException e) {
            throw new TransferFailedException("Unable to create ZIP archive of directory", e);
        }
        wagon.put(zipFile, ScpHelper.getPath(destDir, zipFile.getName()));
        try {
            this.executor.executeCommand("cd " + path + "; unzip -q -o " + zipFile.getName() + "; rm -f " + zipFile.getName());
            zipFile.delete();
            RepositoryPermissions permissions = repository.getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executor.executeCommand("chgrp -Rf " + permissions.getGroup() + " " + path);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executor.executeCommand("chmod -Rf " + permissions.getFileMode() + " " + path);
            }
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", e);
        }
    }

    public List getFileList(String destinationDirectory, Repository repository) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            String path = ScpHelper.getPath(repository.getBasedir(), destinationDirectory);
            Streams streams = this.executor.executeCommand("ls -FlA " + path, false);
            return new LSParser().parseFiles(streams.getOut());
        }
        catch (CommandExecutionException e) {
            if (e.getMessage().trim().endsWith("No such file or directory")) {
                throw new ResourceDoesNotExistException(e.getMessage().trim());
            }
            if (e.getMessage().trim().endsWith("Not a directory")) {
                throw new ResourceDoesNotExistException(e.getMessage().trim());
            }
            throw new TransferFailedException("Error performing file listing.", e);
        }
    }

    public boolean resourceExists(String resourceName, Repository repository) throws TransferFailedException, AuthorizationException {
        try {
            String path = ScpHelper.getPath(repository.getBasedir(), resourceName);
            this.executor.executeCommand("ls " + path);
            return true;
        }
        catch (CommandExecutionException e) {
            return false;
        }
    }

    public void createRemoteDirectories(String path, RepositoryPermissions permissions) throws CommandExecutionException {
        String dirPerms;
        String umaskCmd = null;
        if (permissions != null && (dirPerms = permissions.getDirectoryMode()) != null) {
            umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor(dirPerms);
        }
        String mkdirCmd = "mkdir -p " + path;
        if (umaskCmd != null) {
            mkdirCmd = umaskCmd + "; " + mkdirCmd;
        }
        this.executor.executeCommand(mkdirCmd);
    }
}

