/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.EmbeddedMavenClient;
import org.nuxeo.build.maven.MavenClientFactory;

public class Main {
    public static void main(String[] args) throws BuildException, IOException {
        MavenClientFactory.setInstance(new EmbeddedMavenClient());
        AntClient ant = new AntClient();
        ArrayList<String> targets = new ArrayList<String>();
        String profiles = null;
        File buildFile = null;
        for (String arg : args) {
            if (arg.startsWith("-f")) {
                buildFile = new File(arg.substring(2));
                continue;
            }
            if (arg.startsWith("-p")) {
                profiles = arg.substring(2);
                continue;
            }
            targets.add(arg);
        }
        if (profiles != null) {
            MavenClientFactory.getInstance().getAntProfileManager().activateProfiles(profiles);
        }
        if (buildFile == null) {
            buildFile = new File("build.xml");
        }
        buildFile = buildFile.getCanonicalFile();
        if (targets.isEmpty()) {
            ant.run(buildFile);
        } else {
            ant.run(buildFile, targets);
        }
    }
}

