/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.nuxeo.build.maven.MavenClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntClient {
    public static final String MAVEN_CLIENT_REF = "maven.client.ref";
    protected ClassLoader loader;
    protected Project project;
    protected MavenClient maven;
    Map<String, String> globalProperties;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 8192;

    public AntClient() {
        this(null);
    }

    public AntClient(ClassLoader loader) {
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = AntClient.class.getClassLoader();
        }
        this.loader = loader;
    }

    public void setGlobalProperties(Map<String, String> globalProperties) {
        this.globalProperties = globalProperties;
    }

    public void setMavenClient(MavenClient maven) {
        this.maven = maven;
    }

    public MavenClient getMavenClient() {
        return this.maven;
    }

    public Project getProject() {
        return this.project;
    }

    public void run(File buildFile) throws BuildException {
        this.run(buildFile, (List<String>)null);
    }

    public void run(URL buildFile) throws BuildException {
        this.globalProperties.put("maven.basedir", ".");
        this.run(AntClient.saveURL(buildFile), null);
    }

    public void run(URL buildFile, List<String> targets) throws BuildException {
        this.globalProperties.put("maven.basedir", ".");
        this.run(AntClient.saveURL(buildFile), targets);
    }

    public void run(File buildFile, List<String> targets) throws BuildException {
        PrintStream previousErr = System.err;
        PrintStream previousOut = System.out;
        InputStream in = System.in;
        this.project = new Project();
        this.project.setCoreLoader(this.loader);
        DefaultInputHandler handler = new DefaultInputHandler();
        this.project.setInputHandler(handler);
        this.configureIO(false);
        this.project.setKeepGoingMode(false);
        this.project.setBaseDir(new File(this.globalProperties.get("maven.basedir")));
        this.project.setUserProperty("ant.file", buildFile.getPath());
        this.project.setUserProperty("ant.version", Main.getAntVersion());
        if (this.globalProperties != null) {
            for (Map.Entry<String, String> entry : this.globalProperties.entrySet()) {
                this.project.setUserProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.maven != null) {
            this.project.addReference(MAVEN_CLIENT_REF, this.maven);
        }
        this.project.addBuildListener(this.createLogger());
        this.project.fireBuildStarted();
        try {
            this.project.init();
            ProjectHelper.configureProject(this.project, buildFile);
            if (targets != null) {
                this.project.getExecutor().executeTargets(this.project, targets.toArray(new String[targets.size()]));
            } else {
                this.project.getExecutor().executeTargets(this.project, new String[]{this.project.getDefaultTarget()});
            }
            this.project.fireBuildFinished(null);
        }
        catch (BuildException e) {
            this.project.fireBuildFinished(e);
            throw e;
        }
        finally {
            System.setOut(previousOut);
            System.setErr(previousErr);
            System.setIn(in);
        }
    }

    protected void configureIO(boolean allowInput) {
        if (allowInput) {
            this.project.setDefaultInputStream(System.in);
        }
        System.setIn(new DemuxInputStream(this.project));
        System.setOut(new PrintStream(new DemuxOutputStream(this.project, false)));
        System.setErr(new PrintStream(new DemuxOutputStream(this.project, true)));
    }

    private BuildLogger createLogger() {
        DefaultLogger logger = new DefaultLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(out);
        logger.setErrorPrintStream(err);
        return logger;
    }

    public static File saveURL(URL url) {
        InputStream in = null;
        try {
            File file = File.createTempFile("ant_client_url_", ".tmp");
            file.deleteOnExit();
            in = url.openStream();
            AntClient.copyToFile(in, file);
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(InputStream in, File file) throws IOException {
        FileOutputStream os = null;
        try {
            int read;
            os = new FileOutputStream(file);
            byte[] buffer = AntClient.createBuffer(in.available());
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, read);
            }
        }
        finally {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
    }

    private static byte[] createBuffer(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 65536;
        }
        if (preferredSize > 0x100000) {
            preferredSize = 0x100000;
        } else if (preferredSize < 8192) {
            preferredSize = 8192;
        }
        return new byte[preferredSize];
    }
}

