/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.nuxeo.build.ant.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDuplicateTask
extends Task {
    private static final Pattern PATTERN = Pattern.compile("-([0-9]+.*)\\.jar");
    protected File dir;

    public void setDir(File dir) {
        this.dir = dir;
    }

    @Override
    public void execute() throws BuildException {
        if (this.dir == null) {
            throw new BuildException("dir attribute is required");
        }
        RemoveDuplicateTask.process(this.getProject(), this.dir);
    }

    static void process(Project project, File dir) {
        String[] names = dir.list();
        if (names == null) {
            return;
        }
        HashMap<String, ArrayList<Entry>> map = new HashMap<String, ArrayList<Entry>>();
        for (String name : names) {
            Matcher m = PATTERN.matcher(name);
            if (!m.find()) continue;
            String key = name.substring(0, m.start());
            String v = m.group(1);
            Entry entry = new Entry(new File(dir, name), new Version(v));
            ArrayList<Entry> list = (ArrayList<Entry>)map.get(key);
            if (list == null) {
                list = new ArrayList<Entry>();
                map.put(key, list);
            }
            list.add(entry);
        }
        for (List list : map.values()) {
            RemoveDuplicateTask.removeAllButLatest(project, list);
        }
    }

    public static Entry getLatest(List<Entry> list) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<Entry> it = list.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Entry latest = it.next();
        while (it.hasNext()) {
            Entry p = it.next();
            if (!p.version.greaterThan(latest.version)) continue;
            latest = p;
        }
        return latest;
    }

    public static void removeAllButLatest(Project project, List<Entry> list) {
        Entry latest = RemoveDuplicateTask.getLatest(list);
        StringBuilder buf = new StringBuilder();
        for (Entry p : list) {
            if (p == latest) continue;
            buf.append(p.file.getName()).append(" ");
            p.file.delete();
        }
        if (buf.length() > 0) {
            if (project != null) {
                project.log("removed duplicates: " + buf.toString() + "; preserved: " + latest.file.getName());
            } else {
                System.out.println("removed duplicates: " + buf.toString() + "; preserved: " + latest.file.getName());
            }
        }
    }

    public static void main(String[] args) {
        RemoveDuplicateTask.process(null, new File("/Users/bstefanescu/work/nuxeo/nuxeo-distribution/nuxeo-distribution-dm/target/nuxeo.ear/lib2"));
    }

    static class Entry {
        protected File file;
        protected Version version;

        Entry(File file, Version version) {
            this.file = file;
            this.version = version;
        }
    }
}

