/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.ftl;

import freemarker.cache.FileTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.nuxeo.build.maven.MavenClientFactory;

public class FreemarkerEngine {
    protected Configuration cfg = this.getDefaultConfiguration();

    public void setBaseDir(File baseDir) throws BuildException {
        try {
            this.cfg.setTemplateLoader(new FileTemplateLoader(baseDir));
        }
        catch (Exception e) {
            throw new BuildException("Failed toc reate freemarker configuration", e);
        }
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setWhitespaceStripping(true);
        configuration.setLocalizedLookup(false);
        configuration.setClassicCompatible(true);
        return configuration;
    }

    public Object createInput(Project project) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.putAll(project.getProperties());
        root.put("ant", project.getProperties());
        root.put("system", System.getProperties());
        root.put("profiles", MavenClientFactory.getInstance().getAntProfileManager());
        root.put("graph", MavenClientFactory.getInstance().getGraph());
        return root;
    }

    public Template getTemplate(String name) {
        try {
            return this.cfg.getTemplate(name);
        }
        catch (Exception e) {
            throw new BuildException("Failed to create template " + name, e);
        }
    }

    public void process(Project project, String name, Writer writer) {
        this.process(this.createInput(project), name, writer);
    }

    public void process(Object input, String name, Writer writer) {
        try {
            Template tpl = this.cfg.getTemplate(name);
            tpl.process(input, writer);
        }
        catch (Exception e) {
            throw new BuildException("Failed to process template " + name, e);
        }
    }
}

