/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.profile;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.nuxeo.build.ant.profile.AntProfileManager;
import org.nuxeo.build.maven.MavenClientFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources
extends DataType
implements ResourceCollection {
    protected List<ResourceCollection> sets;
    protected File baseDir;

    public Resources(Project project, File baseDir) {
        this.baseDir = baseDir;
        this.sets = new ArrayList<ResourceCollection>();
        AntProfileManager mgr = MavenClientFactory.getInstance().getAntProfileManager();
        for (String name : baseDir.list()) {
            if (name.equals("default") || mgr.isProfileActive(name)) {
                FileSet fs = new FileSet();
                fs.setDir(new File(baseDir, name));
                this.sets.add(fs);
                continue;
            }
            project.log("Skiping disabled resource directory: " + name);
        }
    }

    @Override
    public boolean isFilesystemOnly() {
        return true;
    }

    @Override
    public Iterator<Resource> iterator() {
        return new CompositeIterator(this.sets);
    }

    @Override
    public int size() {
        int len = 0;
        for (ResourceCollection set : this.sets) {
            len += set.size();
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompositeIterator
    implements Iterator<Resource> {
        Iterator<Resource>[] its;
        int offset;

        public CompositeIterator(List<ResourceCollection> cols) {
            this.its = new Iterator[cols.size()];
            for (int i = 0; i < this.its.length; ++i) {
                this.its[i] = cols.get(i).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.offset >= this.its.length) {
                return false;
            }
            if (this.its[this.offset].hasNext()) {
                return true;
            }
            if (this.offset + 1 >= this.its.length) {
                return false;
            }
            return this.its[this.offset + 1].hasNext();
        }

        @Override
        public Resource next() {
            if (this.offset >= this.its.length) {
                throw new NoSuchElementException("no more elements");
            }
            if (!this.its[this.offset].hasNext()) {
                ++this.offset;
                if (this.offset >= this.its.length) {
                    throw new NoSuchElementException("no more elements");
                }
            }
            return this.its[this.offset].next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

