/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.ant.profile.AntProfileManager;
import org.nuxeo.build.maven.Logger;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntBuildMojo
extends AbstractMojo
implements MavenClient {
    protected Graph graph;
    protected AntProfileManager antProfileManager;
    protected File buildFile;
    protected File[] buildFiles;
    protected String target;
    protected String[] targets;
    protected int expand;
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected ArtifactRepository localRepository;
    protected List<ArtifactRepository> remoteRepositories;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected MavenProjectBuilder projectBuilder;
    private Logger logger;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        AntClient ant = new AntClient();
        MavenClientFactory.setInstance(this);
        this.logger = new Logger(){

            public void debug(String message) {
                AntBuildMojo.this.getLog().debug(message);
            }

            public void debug(String message, Throwable error) {
                AntBuildMojo.this.getLog().debug(message, error);
            }

            public void error(String message) {
                AntBuildMojo.this.getLog().error(message);
            }

            public void error(String message, Throwable error) {
                AntBuildMojo.this.getLog().error(message, error);
            }

            public void info(String message) {
                AntBuildMojo.this.getLog().info(message);
            }

            public void info(String message, Throwable error) {
                AntBuildMojo.this.getLog().info(message, error);
            }

            public void warn(String message) {
                AntBuildMojo.this.getLog().warn(message);
            }

            public void warn(String message, Throwable error) {
                AntBuildMojo.this.getLog().warn(message, error);
            }

            public boolean isDebugEnabled() {
                return AntBuildMojo.this.getLog().isDebugEnabled();
            }
        };
        this.antProfileManager = new AntProfileManager();
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
            props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        props.put("maven.basedir", this.project.getBasedir().getAbsolutePath());
        props.put("maven.project.name", this.project.getName());
        props.put("maven.project.artifactId", this.project.getArtifactId());
        props.put("maven.project.groupId", this.project.getGroupId());
        props.put("maven.project.version", this.project.getVersion());
        props.put("maven.project.packaging", this.project.getPackaging());
        props.put("maven.project.id", this.project.getId());
        props.put("maven.project.build.directory", this.project.getBuild().getDirectory());
        props.put("maven.project.build.outputDirectory", this.project.getBuild().getOutputDirectory());
        props.put("maven.project.build.finalName", this.project.getBuild().getFinalName());
        List<Profile> profiles = this.getActiveProfiles();
        for (Profile profile : profiles) {
            this.antProfileManager.activateProfile(profile.getId(), true);
            props.put("maven.profile." + profile.getId(), "true");
        }
        ant.setGlobalProperties(props);
        if (this.buildFile != null && this.buildFiles != null && this.buildFiles.length > 0) {
            throw new MojoExecutionException("The configuration parameters 'buildFile' and 'buildFiles' cannot both be used.");
        }
        if (this.buildFiles == null || this.buildFiles.length == 0) {
            if (this.buildFile == null) {
                this.buildFile = new File("build.xml");
            }
            this.buildFiles = new File[]{this.buildFile};
        }
        if (this.target != null && this.targets != null && this.targets.length > 0) {
            throw new MojoExecutionException("The configuration parameters 'target' and 'targets' cannot both be used.");
        }
        if ((this.targets == null || this.targets.length == 0) && this.target != null) {
            this.targets = new String[]{this.target};
        }
        for (File file : this.buildFiles) {
            this.graph = new Graph(this);
            Node root = this.graph.addRootNode(this.project);
            if (this.expand > 0) {
                root.expand(this.expand, null);
            }
            try {
                if (this.targets != null && this.targets.length > 0) {
                    ant.run(file, Arrays.asList(this.targets));
                    continue;
                }
                ant.run(file);
            }
            catch (BuildException e) {
                throw new MojoExecutionException("Failed to run " + file, e);
            }
        }
    }

    @Override
    public List<Profile> getActiveProfiles() {
        return this.project.getActiveProfiles();
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public ArtifactFactory getArtifactFactory() {
        return this.factory;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.resolver;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public MavenProjectBuilder getProjectBuilder() {
        return this.projectBuilder;
    }

    @Override
    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> otherRemoteRepositories) throws ArtifactNotFoundException {
        try {
            this.resolver.resolve(artifact, otherRemoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
    }

    @Override
    public void resolve(Artifact artifact) throws ArtifactNotFoundException {
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public AntProfileManager getAntProfileManager() {
        return this.antProfileManager;
    }

    @Override
    public Logger getCommonLogger() {
        return this.logger;
    }
}

