/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.tools.ant.BuildException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuxeo.build.ant.profile.AntProfileManager;
import org.nuxeo.build.maven.Logger;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenEmbedder;
import org.nuxeo.build.maven.graph.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedMavenClient
extends MavenEmbedder
implements MavenClient {
    protected Graph graph;
    protected File settingsFile;
    private List<ArtifactRepository> remoteRepos;
    protected AntProfileManager profileMgr = new AntProfileManager();
    protected Logger mylogger;

    public EmbeddedMavenClient() {
        this(null);
    }

    public EmbeddedMavenClient(ClassLoader loader) {
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = EmbeddedMavenClient.class.getClassLoader();
        }
        this.setClassLoader(loader);
        this.graph = new Graph(this);
        this.mylogger = new MyLogger();
        this.logger = new MavenEmbedderConsoleLogger();
    }

    @Override
    public List<Profile> getActiveProfiles() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public MavenProjectHelper getProjectHelper() {
        try {
            return (MavenProjectHelper)this.embedder.lookup(MavenProjectHelper.ROLE);
        }
        catch (Exception e) {
            throw new BuildException("Failed to lookup maven project helper");
        }
    }

    @Override
    public AntProfileManager getAntProfileManager() {
        return this.profileMgr;
    }

    public boolean isStarted() {
        return this.embedder != null;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    @Override
    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public Embedder getPlexusEmbedder() {
        return this.embedder;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @Override
    public MavenProjectBuilder getProjectBuilder() {
        return this.mavenProjectBuilder;
    }

    public void setSettings(File settingsFile) {
        this.settingsFile = settingsFile;
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Override
    protected void createMavenSettings() throws MavenEmbedderException, ComponentLookupException {
        if (this.settingsFile != null) {
            this.settingsBuilder = (MavenSettingsBuilder)this.embedder.lookup(MavenSettingsBuilder.ROLE);
            try {
                this.settings = this.settingsBuilder.buildSettings(this.settingsFile);
            }
            catch (IOException e) {
                throw new MavenEmbedderException("Error creating settings.", e);
            }
            catch (XmlPullParserException e) {
                throw new MavenEmbedderException("Error creating settings.", e);
            }
        } else {
            super.createMavenSettings();
        }
        this.settings.setOffline(this.offline);
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        if (this.remoteRepos == null) {
            try {
                this.remoteRepos = this.buildRepositoriesFromProfiles();
                this.addDefaultRepositories();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.remoteRepos = new ArrayList<ArtifactRepository>();
            }
        }
        return this.remoteRepos;
    }

    protected void addDefaultRepositories() {
        Repository repo = new Repository();
        repo.setId("central");
        repo.setUrl("http://repo1.maven.org/maven2");
        repo.setLayout("default");
        RepositoryPolicy policy = new RepositoryPolicy();
        policy.setEnabled(false);
        repo.setSnapshots(policy);
        this.addRemoteRepository(repo);
    }

    public void addRemoteRepository(Repository repo) {
        try {
            ArtifactRepository arepo = ProjectUtils.buildArtifactRepository(repo, this.artifactRepositoryFactory, this.getPlexusEmbedder().getContainer());
            this.getRemoteRepositories().add(arepo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resolve(Artifact artifact) throws ArtifactNotFoundException {
        this.resolve(artifact, this.getRemoteRepositories());
    }

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories) throws ArtifactNotFoundException {
        try {
            super.resolve(artifact, remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ArtifactRepository> buildRepositoriesFromProfiles() throws Exception {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        List profiles = this.getProfileManager().getActiveProfiles();
        for (Profile profile : profiles) {
            List<Repository> prepos = profile.getRepositories();
            for (Repository mavenRepo : prepos) {
                ArtifactRepository artifactRepo = null;
                try {
                    artifactRepo = ProjectUtils.buildArtifactRepository(mavenRepo, this.artifactRepositoryFactory, this.getPlexusEmbedder().getContainer());
                }
                catch (InvalidRepositoryException e) {
                    throw new Exception("Failed to build profile repositories", e);
                }
                repos.add(artifactRepo);
            }
        }
        return repos;
    }

    public List<ArtifactRepository> buildArtifactRepositories(Model model) throws Exception {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        List<Repository> mavenRepos = model.getRepositories();
        for (Repository mavenRepo : mavenRepos) {
            ArtifactRepository artifactRepo = null;
            try {
                artifactRepo = ProjectUtils.buildArtifactRepository(mavenRepo, this.artifactRepositoryFactory, this.getPlexusEmbedder().getContainer());
            }
            catch (InvalidRepositoryException e) {
                throw new Exception("Failed to build profile repositories", e);
            }
            repos.add(artifactRepo);
        }
        return repos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model readModel(String projectId, File pom, boolean strict) throws Exception {
        FileReader reader = new FileReader(pom);
        try {
            Model model = this.readModel(projectId, pom.getAbsolutePath(), reader, strict);
            return model;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model readModel(String projectId, URL pom, boolean strict) throws Exception {
        InputStreamReader reader = new InputStreamReader(pom.openStream());
        try {
            Model model = this.readModel(projectId, pom.toExternalForm(), reader, strict);
            return model;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public Model readModel(String projectId, String pomLocation, Reader reader, boolean strict) throws IOException, InvalidProjectModelException {
        String modelSource = IOUtil.toString(reader);
        if (modelSource.indexOf("<modelVersion>4.0.0") < 0) {
            throw new InvalidProjectModelException(projectId, pomLocation, "Not a v4.0.0 POM.");
        }
        StringReader sReader = new StringReader(modelSource);
        try {
            return this.modelReader.read(sReader, strict);
        }
        catch (XmlPullParserException e) {
            throw new InvalidProjectModelException(projectId, pomLocation, "Parse error reading POM. Reason: " + e.getMessage(), e);
        }
    }

    @Override
    public Logger getCommonLogger() {
        return new MyLogger();
    }

    class MyLogger
    implements Logger {
        MyLogger() {
        }

        public void debug(String message) {
            EmbeddedMavenClient.this.logger.debug(message);
        }

        public void debug(String message, Throwable error) {
            EmbeddedMavenClient.this.logger.debug(message, error);
        }

        public void error(String message) {
            EmbeddedMavenClient.this.logger.error(message);
        }

        public void error(String message, Throwable error) {
            EmbeddedMavenClient.this.logger.error(message, error);
        }

        public void info(String message) {
            EmbeddedMavenClient.this.logger.info(message);
        }

        public void info(String message, Throwable error) {
            EmbeddedMavenClient.this.logger.info(message, error);
        }

        public void warn(String message) {
            EmbeddedMavenClient.this.logger.warn(message);
        }

        public void warn(String message, Throwable error) {
            EmbeddedMavenClient.this.logger.warn(message, error);
        }

        public boolean isDebugEnabled() {
            return EmbeddedMavenClient.this.logger.isDebugEnabled();
        }
    }
}

