/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.swing.tree.ArtifactTree;
import org.nuxeo.build.swing.tree.ItemProvider;

public class ArtifactCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    protected ArtifactTree tree;

    public ArtifactCellRenderer(ArtifactTree tree) {
        this.tree = tree;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)value;
        Object o = tn.getUserObject();
        if (o instanceof Node) {
            Node node = (Node)o;
            this.processNode(this.tree.getProvider(), node, sel, expanded);
        }
        return this;
    }

    protected void processNode(ItemProvider provider, Node node, boolean isSelected, boolean isExpanded) {
        Font font;
        Icon icon = provider.getIcon(node, isExpanded);
        if (icon != null) {
            this.setIcon(icon);
        }
        this.setText(provider.getName(node));
        this.setToolTipText(provider.getTooltip(node));
        Color color = provider.getForegroundColor(node, isSelected);
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = provider.getBackgroundColor(node, isSelected)) != null) {
            this.setBackground(color);
        }
        if ((font = provider.getFont(node)) != null) {
            this.setFont(font);
        }
    }
}

