/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dev;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.EmbeddedMavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.util.FileUtils;
import org.nuxeo.build.util.ZipUtils;
import org.nuxeo.dev.ClassLoaderDelegate;
import org.nuxeo.dev.ConfigurationLoader;
import org.nuxeo.dev.IsolatedClassLoader;
import org.nuxeo.dev.MyFrameworkBootstrap;
import org.nuxeo.osgi.application.MutableClassLoader;

public class NuxeoApp {
    public static final String CORE_SERVER_532 = "core-5.3.2";
    public static final String CORE_SERVER_531 = "core-5.3.1";
    public static final String CORE_SERVER_530 = "core-5.3.0";
    public static final String CORE_SERVER_540 = "core-5.4.0";
    public static final String CORE_SERVER_541_SNAPSHOT = "core-5.4.1-SNAPSHOT";
    public static final String DEFAULT = "core-5.4.1-SNAPSHOT";
    protected File home;
    protected EmbeddedMavenClient maven;
    protected Map<String, File> bundles;
    protected List<String> bundlePatterns;
    protected MyFrameworkBootstrap bootstrap;
    protected boolean isIsolated = true;
    protected boolean isVerbose;
    protected boolean isOffline;
    protected ConfigurationLoader loader;
    protected String updatePolicy = "daily";
    protected String[] externalBundles;
    protected String[] externalLibs;

    public static NuxeoApp createTestNuxeoApp() throws Exception {
        File file = File.createTempFile("nuxeo-app", ".tmp");
        file.delete();
        file.mkdirs();
        return new NuxeoApp(file);
    }

    public NuxeoApp(File home) throws Exception {
        this(home, null, true);
    }

    public NuxeoApp(File home, ClassLoader cl, boolean isIsolated) throws Exception {
        this.home = home;
        this.isIsolated = isIsolated;
        this.bundlePatterns = new ArrayList<String>();
        this.bundlePatterns.add("nuxeo-");
        this.bundles = new LinkedHashMap<String, File>();
        this.bootstrap = new MyFrameworkBootstrap(this, this.createMutableCL(cl));
    }

    private MutableClassLoader createMutableCL(ClassLoader parent) {
        if (parent == null) {
            parent = NuxeoApp.findContextClassLoader();
        }
        if (this.isIsolated) {
            return new IsolatedClassLoader(parent);
        }
        return new ClassLoaderDelegate(parent);
    }

    public void setExternalBundles(String[] externalBundles) {
        this.externalBundles = externalBundles;
    }

    public void setExternalLibs(String[] externalLibs) {
        this.externalLibs = externalLibs;
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public void clearBundlePatterns() {
        this.bundlePatterns.clear();
    }

    public void addBundlePattern(String pattern) {
        this.bundlePatterns.add(pattern);
    }

    public EmbeddedMavenClient getMaven() {
        return this.maven;
    }

    public File getHome() {
        return this.home;
    }

    public void setOffline(boolean isOffline) {
        this.isOffline = isOffline;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public void build(URL config) throws Exception {
        this.build(config, false);
    }

    public void build(String profile) throws Exception {
        this.build(profile, false);
    }

    public void build(String profile, boolean enableCache) throws Exception {
        URL url = NuxeoApp.class.getResource(profile + ".cfg");
        if (url == null) {
            throw new IllegalArgumentException("profile is not known: " + profile);
        }
        this.build(url, enableCache);
    }

    public void build(URL url, boolean enableCache) throws Exception {
        File cacheFile;
        this.initCL();
        if (enableCache && (cacheFile = new File(this.home, "tmp/build.cache")).isFile()) {
            this.loadConfigurationFromCache(cacheFile);
            this.bootstrap.initialize();
            return;
        }
        this.loadConfiguration(url);
        this.bootstrap.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(File file) throws Exception {
        FileInputStream in = new FileInputStream(file);
        try {
            this.loadConfiguration(in);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(URL url) throws Exception {
        InputStream in = url.openStream();
        try {
            this.loadConfiguration(in);
        }
        finally {
            in.close();
        }
    }

    protected boolean acceptClassPathBundle(URL url) {
        for (String pattern : this.bundlePatterns) {
            if (!url.getPath().contains(pattern)) continue;
            return true;
        }
        return false;
    }

    public void setVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    protected void initCL() throws Exception {
        if (this.isIsolated) {
            this.initIsolatedCL();
        } else {
            this.initSharedCL();
        }
    }

    protected void initSharedCL() throws Exception {
        URL[] urls;
        MutableClassLoader delegate = this.bootstrap.getLoader();
        for (URL url : urls = delegate.getURLs()) {
            if (!"file".equals(url.getProtocol()) || !this.acceptClassPathBundle(url)) continue;
            File jar = FileUtils.urlToFile(url);
            String symName = null;
            try {
                Manifest mf = NuxeoApp.getManifest(jar);
                symName = NuxeoApp.getSymbolicName(mf);
                if (symName == null) continue;
                this.bundles.put(symName, jar);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void initIsolatedCL() throws Exception {
        MutableClassLoader cl = this.bootstrap.getLoader();
        if (this.externalBundles != null) {
            for (String path : this.externalBundles) {
                File file = new File(path);
                URL url = file.toURI().toURL();
                Manifest mf = NuxeoApp.getManifest(file);
                cl.addURL(url);
                String symName = NuxeoApp.getSymbolicName(mf);
                if (symName == null) continue;
                this.bundles.put(symName, file);
            }
        }
        if (this.externalLibs != null) {
            for (String path : this.externalLibs) {
                URL url = new File(path).toURI().toURL();
                cl.addURL(url);
            }
        }
    }

    public void loadConfiguration(InputStream in) throws Exception {
        URL url;
        File jar;
        System.out.println("Building Application ...");
        double s = System.currentTimeMillis();
        this.initializeMaven();
        this.loader = new ConfigurationLoader();
        this.loader.getReader().read(in);
        this.initializeGraph();
        Graph graph = this.maven.getGraph();
        MutableClassLoader delegate = this.bootstrap.getLoader();
        this.copyTemplateFiles(this.loader.getTemplateArtifact(), this.loader.getTemplatePrefix(), this.home);
        StringBuilder cache = new StringBuilder();
        Set<String> builtinBundles = this.loader.getBundles();
        for (String key : builtinBundles) {
            Node node = null;
            String classifier = null;
            if (key.startsWith("!")) {
                node = graph.addRootNode(key.substring(1));
            } else {
                int p = key.indexOf(59);
                if (p > -1) {
                    classifier = key.substring(p + 1);
                    key = key.substring(0, p);
                }
                node = graph.findFirst(key);
            }
            if (node == null) {
                throw new RuntimeException("Failed to lookup artifact in graph: " + key);
            }
            if (this.isVerbose) {
                System.out.println("Resolving artifact: " + node);
            }
            if ((jar = classifier == null ? node.getFile() : node.getFile(classifier)) == null) continue;
            url = jar.toURI().toURL();
            Manifest mf = NuxeoApp.getManifest(jar);
            String symbolicName = NuxeoApp.getSymbolicName(mf);
            if (symbolicName != null) {
                if (!this.bundles.containsKey(symbolicName)) {
                    this.bundles.put(symbolicName, jar);
                    delegate.addURL(url);
                }
                cache.append(symbolicName + "@" + jar.getAbsolutePath()).append("\n");
                continue;
            }
            cache.append(jar.getAbsolutePath()).append("\n");
            delegate.addURL(url);
        }
        cache.append("\n");
        Set<String> builtinLibs = this.loader.getLibs();
        for (String key : builtinLibs) {
            Node node = null;
            node = key.startsWith("!") ? graph.addRootNode(key.substring(1)) : graph.findFirst(key);
            if (node == null) {
                throw new RuntimeException("Failed to lookup artifact in graph: " + key);
            }
            jar = node.getFile();
            if (jar == null) continue;
            url = jar.toURI().toURL();
            delegate.addURL(url);
            cache.append(url.toExternalForm()).append("\n");
        }
        File cacheFile = new File(this.home, "tmp/build.cache");
        cacheFile.getParentFile().mkdirs();
        FileUtils.writeFile(cacheFile, cache.toString());
        System.out.println("Build took: " + ((double)System.currentTimeMillis() - s) / 1000.0);
        this.buildDone();
        this.loader = null;
    }

    public void loadConfigurationFromCache(File cacheFile) throws Exception {
        System.out.print("Building Application from Cache ... ");
        double s = System.currentTimeMillis();
        BufferedReader reader = new BufferedReader(new FileReader(cacheFile));
        String line = reader.readLine();
        boolean isBundle = true;
        MutableClassLoader delegate = this.bootstrap.getLoader();
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                isBundle = false;
                line = reader.readLine();
                continue;
            }
            if (isBundle) {
                int p = line.indexOf(64);
                if (p == -1) {
                    delegate.addURL(new URL(line));
                } else {
                    File file = new File(line.substring(p + 1));
                    String symName = line.substring(0, p);
                    if (!this.bundles.containsKey(symName)) {
                        this.bundles.put(symName, file);
                        delegate.addURL(file.toURI().toURL());
                    }
                }
            } else {
                delegate.addURL(new URL(line));
            }
            line = reader.readLine();
        }
        System.out.println(((double)System.currentTimeMillis() - s) / 1000.0);
    }

    public void start() throws Exception {
        this.aboutToStartFramework();
        this.bootstrap.start();
        this.frameworkStarted();
    }

    protected void aboutToStartFramework() throws Exception {
        System.setProperty("org.nuxeo.runtime.redirectJUL", "false");
        String h2 = System.getProperty("h2.baseDir");
        if (h2 == null) {
            h2 = new File(this.home, "data/h2").getAbsolutePath();
            System.setProperty("h2.baseDir", h2);
        }
        String homePath = this.home.getAbsolutePath();
        System.setProperty("nuxeo.home", homePath);
        if (System.getProperty("jetty.home") == null) {
            System.setProperty("jetty.home", homePath);
        }
        if (System.getProperty("jetty.logs") == null) {
            System.setProperty("jetty.logs", homePath + "/log");
        }
        if (System.getProperty("derby.system.home") == null) {
            System.setProperty("derby.system.home", homePath + "/data/derby");
        }
    }

    protected void frameworkStarted() throws Exception {
    }

    public static ClassLoader findContextClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = NuxeoApp.class.getClassLoader();
        }
        return cl;
    }

    protected EmbeddedMavenClient createEmbeddedMaven() {
        return new EmbeddedMavenClient();
    }

    protected void initializeMaven() throws Exception {
        this.maven = this.createEmbeddedMaven();
        MavenClientFactory.setInstance(this.maven);
        this.maven.setOffline(this.isOffline);
        this.maven.start();
        this.maven.getGraph().setShouldLoadDependencyManagement(true);
        Repository repo = new Repository();
        repo.setId("public");
        repo.setName("Nuxeo Public Repository");
        repo.setLayout("default");
        repo.setUrl("http://maven.nuxeo.org/public");
        RepositoryPolicy policy = new RepositoryPolicy();
        policy.setEnabled(true);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("warn");
        repo.setReleases(policy);
        policy = new RepositoryPolicy();
        policy.setEnabled(false);
        repo.setSnapshots(policy);
        this.maven.addRemoteRepository(repo);
        repo = new Repository();
        repo.setId("public-snapshot");
        repo.setName("Nuxeo Public Snapshot Repository");
        repo.setLayout("default");
        repo.setUrl("http://maven.nuxeo.org/public-snapshot");
        policy = new RepositoryPolicy();
        policy.setEnabled(false);
        repo.setReleases(policy);
        policy = new RepositoryPolicy();
        policy.setEnabled(true);
        policy.setUpdatePolicy(this.updatePolicy);
        policy.setChecksumPolicy("warn");
        repo.setSnapshots(policy);
        this.maven.addRemoteRepository(repo);
    }

    protected void initializeGraph() throws Exception {
        for (String pom : this.loader.getPoms()) {
            this.addPom(pom);
        }
    }

    protected Node addPom(String groupId, String artifactId, String version) {
        return this.addArtifact(groupId, artifactId, version, "pom", null, 1);
    }

    protected Node addPom(String groupId, String artifactId, String version, int expandDepth) {
        return this.addArtifact(groupId, artifactId, version, "pom", null, expandDepth);
    }

    protected Node addArtifact(String groupId, String artifactId, String version) {
        return this.addArtifact(groupId, artifactId, version, null, null, 0);
    }

    protected Node addArtifact(String groupId, String artifactId, String version, String type) {
        return this.addArtifact(groupId, artifactId, version, type, null, 0);
    }

    protected Node addArtifact(String groupId, String artifactId, String version, String type, String classifier) {
        return this.addArtifact(groupId, artifactId, version, type, classifier, 0);
    }

    protected Node addArtifact(String groupId, String artifactId, String version, String type, String classifier, int expandDepth) {
        if (groupId == null || artifactId == null || version == null) {
            throw new IllegalArgumentException("You must specify at least the groupId, artifactId and version when explicitelly adding an artifact to the graph");
        }
        String key = groupId + ":" + artifactId + ":" + version;
        if (type != null) {
            key = key + ":" + type;
        }
        if (classifier != null) {
            if (type == null) {
                type = "jar";
            }
            key = key + ":" + classifier;
        }
        return this.addArtifact(key, expandDepth);
    }

    protected Node addPom(String key) {
        return this.addArtifact(key, 1);
    }

    protected Node addArtifact(String key) {
        return this.addArtifact(key, 0);
    }

    protected Node addArtifact(String key, int expandDepth) {
        Node node = this.maven.getGraph().addRootNode(key);
        if (expandDepth > 0) {
            node.expand(expandDepth, null);
        }
        return node;
    }

    public static void disableHttpServer() {
        System.setProperty("jetty.disable", "true");
    }

    public static void setHttpServerAddress(String host, int port) {
        if (port > 0) {
            System.setProperty("jetty.port", String.valueOf(port));
        }
        if (host != null) {
            System.setProperty("jetty.host", host);
        }
    }

    protected void buildDone() {
    }

    public void shutdown() throws Exception {
        this.bootstrap.stop();
    }

    protected void copyTemplateFiles(ArtifactDescriptor template, String templatePrefix, File targetDir) throws Exception {
        if (template.version == null) {
            throw new IllegalArgumentException("template artifact version cannot be null");
        }
        Artifact artifact = template.classifier == null ? template.toBuildArtifact() : template.toArtifactWithClassifier();
        this.maven.resolve(artifact);
        File file = artifact.getFile();
        if (file == null) {
            throw new FileNotFoundException("No such artifact file: " + file);
        }
        ZipUtils.unzip(templatePrefix, file, this.home);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest getManifest(File file) {
        try {
            if (file.isDirectory()) {
                file = new File(file, "META-INF/MANIFEST.MF");
                FileInputStream in = new FileInputStream(file);
                try {
                    Manifest manifest = new Manifest(in);
                    return manifest;
                }
                finally {
                    in.close();
                }
            }
            JarFile jar = new JarFile(file);
            try {
                Manifest manifest = jar.getManifest();
                return manifest;
            }
            finally {
                jar.close();
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getSymbolicName(Manifest mf) {
        if (mf == null) {
            return null;
        }
        String value = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        if (value == null) {
            return null;
        }
        int p = value.indexOf(59);
        if (p > 0) {
            return value.substring(0, p).trim();
        }
        return value;
    }
}

