/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.maven.filter.DependencyFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    protected Graph graph;
    protected String id;
    protected Artifact artifact;
    protected List<Edge> edgesIn;
    protected List<Edge> edgesOut;
    private boolean isExpanded;
    protected MavenProject pom;
    private List<char[]> acceptedCategories;

    public List<char[]> getAcceptedCategories() {
        if (this.acceptedCategories == null) {
            this.acceptedCategories = new ArrayList<char[]>();
        }
        return this.acceptedCategories;
    }

    public static String createNodeId(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion() + ':' + artifact.getType() + ':';
    }

    public Node(Node node) {
        this.graph = node.graph;
        this.id = node.id;
        this.artifact = node.artifact;
        this.edgesIn = node.edgesIn;
        this.edgesOut = node.edgesOut;
        this.pom = node.pom;
        this.isExpanded = node.isExpanded;
    }

    public Node(Graph graph, MavenProject pom, Artifact artifact) {
        this(graph, pom, artifact, Node.createNodeId(artifact));
    }

    protected Node(Graph graph, MavenProject pom, Artifact artifact, String id) {
        this.graph = graph;
        this.id = id;
        this.artifact = artifact;
        this.pom = pom;
        this.edgesIn = new ArrayList<Edge>();
        this.edgesOut = new ArrayList<Edge>();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public File getFile() {
        this.resolve();
        File file = this.artifact.getFile();
        if (file != null) {
            this.graph.file2artifacts.put(file.getName(), this.artifact);
        }
        return file;
    }

    public File getFile(String classifier) {
        this.resolve();
        Artifact ca = this.graph.maven.getArtifactFactory().createArtifactWithClassifier(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getVersion(), this.artifact.getType(), classifier);
        try {
            this.graph.maven.resolve(ca);
            File file = ca.getFile();
            if (file != null) {
                this.graph.file2artifacts.put(file.getAbsolutePath(), ca);
            }
            return file;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean isRoot() {
        return this.edgesIn.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public List<Edge> getEdgesOut() {
        return this.edgesOut;
    }

    public List<Edge> getEdgesIn() {
        return this.edgesIn;
    }

    public void addEdgeIn(Edge edge) {
        this.edgesIn.add(edge);
    }

    public void addEdgeOut(Edge edge) {
        this.edgesOut.add(edge);
    }

    public MavenProject getPom() {
        this.resolve();
        return this.pom;
    }

    public MavenProject getPomIfAlreadyLoaded() {
        return this.pom;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void expand(int recurse, DependencyFilter filter) {
        if (this.isExpanded) {
            return;
        }
        this.isExpanded = true;
        this.resolve();
        if (this.pom == null) {
            return;
        }
        if (recurse > 0) {
            if ("pom".equals(this.artifact.getType()) && this.graph.shouldLoadDependencyManagement()) {
                this.loadDependencies(recurse - 1, this.pom.getDependencyManagement().getDependencies(), filter);
            }
            this.loadDependencies(recurse - 1, this.pom.getDependencies(), filter);
        }
    }

    public void expand(DependencyFilter filter) {
        this.expand(0, filter);
    }

    public void expandAll(DependencyFilter filter) {
        this.expand(Integer.MAX_VALUE, filter);
    }

    public List<Node> getTrail() {
        if (this.edgesIn.isEmpty()) {
            ArrayList<Node> result = new ArrayList<Node>();
            result.add(this);
            return result;
        }
        Edge edge = this.edgesIn.get(0);
        List<Node> path = edge.src.getTrail();
        path.add(this);
        return path;
    }

    public void resolve() {
        this.graph.getResolver().resolve(this);
    }

    protected void loadDependencies(int recurse, List<Dependency> deps, DependencyFilter filter) {
        ArtifactFactory factory = this.graph.getMaven().getArtifactFactory();
        if (this.getPom() == null) {
            return;
        }
        for (Dependency d : deps) {
            if ("test".equalsIgnoreCase(d.getScope()) || "system".equalsIgnoreCase(d.getScope()) || d.isOptional() || filter != null && !filter.accept(this, d)) continue;
            Artifact a = factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), d.getType(), d.getClassifier(), d.getScope(), false);
            assert (a.getScope().equals(d.getScope()));
            Node newNode = null;
            newNode = this.graph.getNode(a);
            Edge edge = new Edge(this, newNode, d.getScope(), d.isOptional());
            this.addEdgeOut(edge);
            newNode.addEdgeIn(edge);
            if (recurse <= 0) continue;
            newNode.expand(recurse, filter);
        }
    }

    public void collectNodes(Collection<Node> nodes, Filter filter) {
        for (Edge edge : this.edgesOut) {
            if (!filter.accept(edge)) continue;
            nodes.add(edge.dst);
        }
    }

    public void collectNodes(Collection<Node> nodes) {
        for (Edge edge : this.edgesOut) {
            nodes.add(edge.dst);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Node) {
            return ((Node)obj).id.equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    public void setAcceptedCategory(char[] pattern) {
        this.getAcceptedCategories().add(pattern);
    }

    public boolean isAcceptedCategory(List<char[]> patterns) {
        for (char[] pattern : patterns) {
            if (!this.getAcceptedCategories().contains(pattern)) continue;
            return true;
        }
        return false;
    }
}

