/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dev;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import org.nuxeo.dev.NuxeoApp;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File home = null;
        String profile = "core-5.4.1-SNAPSHOT";
        String host = "localhost";
        int port = 8080;
        String config = null;
        String mainType = null;
        String updatePolicy = "daily";
        boolean offline = false;
        String opt = null;
        boolean noCache = false;
        String[] extBundles = null;
        String[] extLibs = null;
        boolean sharedcl = false;
        for (String arg : args) {
            if (arg.equals("-o")) {
                offline = true;
                continue;
            }
            if (arg.equals("--nocache")) {
                noCache = true;
                continue;
            }
            if (arg.equals("-shared")) {
                sharedcl = true;
                continue;
            }
            if (arg.startsWith("-")) {
                opt = arg;
                continue;
            }
            if (opt != null) {
                if ("-p".equals(opt)) {
                    profile = arg;
                } else if ("-u".equals(opt)) {
                    updatePolicy = arg;
                } else if ("-h".equals(opt)) {
                    int p = arg.indexOf(58);
                    if (p != -1) {
                        host = arg.substring(0, p);
                        port = Integer.parseInt(arg.substring(p + 1));
                    } else {
                        host = arg;
                    }
                } else if ("-c".equals(opt)) {
                    config = arg;
                } else if ("-e".equals(opt)) {
                    mainType = arg;
                } else if ("-bundles".equals(opt)) {
                    extBundles = Main.splitCp(arg);
                } else if ("-libs".equals(opt)) {
                    extLibs = Main.splitCp(arg);
                }
                opt = null;
                continue;
            }
            home = arg.startsWith("/") ? new File(arg) : new File(".", arg);
            opt = null;
        }
        if (home == null) {
            System.err.println("Syntax error: You must specify a home directory to be used by the nuxeo server.");
            System.exit(1);
        }
        home = home.getCanonicalFile();
        Method mainMethod = null;
        if (mainType != null) {
            mainMethod = Class.forName(mainType).getMethod("main", String[].class);
        }
        System.out.println("+---------------------------------------------------------");
        System.out.println("| Nuxeo Server Profile: " + (profile == null ? "custom" : profile));
        System.out.println("| Home Directory: " + home);
        System.out.println("| HTTP server at: " + host + ":" + port);
        System.out.println("| Use cache: " + !noCache + "; Snapshot update policy: " + updatePolicy + "; offline: " + offline);
        System.out.println("+---------------------------------------------------------\n");
        final NuxeoApp app = new NuxeoApp(home, null, !sharedcl);
        Thread.currentThread().setContextClassLoader(app.bootstrap.getClassLoader());
        if (extBundles != null) {
            app.setExternalBundles(extBundles);
        }
        if (extLibs != null) {
            app.setExternalLibs(extLibs);
        }
        app.setVerbose(true);
        app.setOffline(offline);
        app.setUpdatePolicy(updatePolicy);
        if (config != null) {
            app.build(Main.makeUrl(config), !noCache);
        } else {
            app.build(profile, !noCache);
        }
        NuxeoApp.setHttpServerAddress(host, port);
        app.start();
        if (mainMethod == null) {
            Runtime.getRuntime().addShutdownHook(new Thread("Nuxeo Server Shutdown"){

                public void run() {
                    try {
                        app.shutdown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            try {
                mainMethod.invoke(null, new Object[]{args});
            }
            finally {
                app.shutdown();
            }
        }
    }

    protected static URL makeUrl(String spec) {
        try {
            if (spec.indexOf(58) > -1) {
                if (spec.startsWith("java:")) {
                    spec = spec.substring(5);
                    ClassLoader cl = Main.getContextClassLoader();
                    URL url = cl.getResource(spec);
                    if (url == null) {
                        Main.fail("Canot found java resource: " + spec);
                    }
                    return url;
                }
                return new URL(spec);
            }
            return new File(spec).toURI().toURL();
        }
        catch (Exception e) {
            Main.fail("Invalid config file soecification. Not a valid URL or file: " + spec);
            return null;
        }
    }

    protected static void fail(String msg) {
        System.err.println(msg);
        System.exit(2);
    }

    protected static ClassLoader getContextClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? Main.class.getClassLoader() : cl;
    }

    protected static String[] splitCp(String expr) {
        if ((expr = expr.trim()).startsWith("\"") && expr.endsWith("\"")) {
            expr = expr.substring(1, expr.length() - 1).trim();
        }
        return Main.split(expr, ':', true);
    }

    public static String[] split(String str, char delimiter, boolean trim) {
        int s = 0;
        int e = str.indexOf(delimiter, s);
        if (e == -1) {
            if (trim) {
                str = str.trim();
            }
            return new String[]{str};
        }
        ArrayList<String> ar = new ArrayList<String>();
        do {
            String segment = str.substring(s, e);
            if (trim) {
                segment = segment.trim();
            }
            ar.add(segment);
        } while ((e = str.indexOf(delimiter, s = e + 1)) != -1);
        int len = str.length();
        if (s < len) {
            String segment = str.substring(s);
            if (trim) {
                segment = segment.trim();
            }
            ar.add(segment);
        } else {
            ar.add("");
        }
        return ar.toArray(new String[ar.size()]);
    }
}

