/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects.blob;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileCleaningTracker;
import org.nuxeo.client.api.objects.NuxeoEntity;

public class Blob
extends NuxeoEntity {
    @JsonIgnore
    protected String mimeType;
    @JsonIgnore
    protected String fileName;
    @JsonIgnore
    protected File file;
    @JsonIgnore
    protected FileCleaningTracker fileCleaningTracker;

    public Blob() {
        super(null);
    }

    public Blob(String fileName) {
        this(fileName, null);
    }

    public Blob(File file) {
        this(file.getName(), "application/octet-stream");
        this.file = file;
    }

    public Blob(String fileName, String mimeType) {
        super(null);
        this.fileName = fileName;
        this.file = null;
        this.setMimeType(mimeType);
    }

    @JsonIgnore
    public int getLength() {
        long length = this.file.length();
        if (length > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)length;
    }

    @JsonIgnore
    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType == null ? "application/octet-stream" : mimeType;
    }

    @JsonIgnore
    protected String formatLength(int len) {
        int k = len / 1024;
        if (k <= 0) {
            return len + " B";
        }
        if (k < 1024) {
            return k + " K";
        }
        return k / 1024 + " M";
    }

    public String toString() {
        return this.fileName + " - " + this.mimeType + " - " + this.formatLength(this.getLength());
    }

    public void track() {
        if (this.file != null) {
            this.fileCleaningTracker = new FileCleaningTracker();
            this.fileCleaningTracker.track(this.file, (Object)this);
        }
    }
}

