/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.internals.spi;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class NuxeoClientException
extends RuntimeException {
    private static final int INTERNAL_ERROR_STATUS = 666;
    protected final int status;
    protected String code;
    protected final String type;
    protected final String info;
    @JsonProperty(value="stacktrace")
    protected final String exception;
    @JsonProperty(value="exception")
    protected final Throwable throwable;
    @JsonProperty(value="entity-type")
    private final String entityType;

    public String getEntityType() {
        return this.entityType;
    }

    public NuxeoClientException(Throwable e) {
        this("error", e);
    }

    public NuxeoClientException(String message, Throwable e) {
        this.throwable = e;
        this.status = 666;
        this.type = "Error";
        this.info = e == null ? null : e.getMessage();
        this.entityType = "exception";
        this.exception = message;
    }

    public NuxeoClientException(int code, String message) {
        this.info = message;
        this.throwable = null;
        this.type = null;
        this.status = code;
        this.entityType = "exception";
        this.exception = null;
    }

    public NuxeoClientException(String message) {
        this(message, null);
    }

    public int getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    protected static String extractInfo(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getRemoteStackTrace() {
        Field[] fields = this.getClass().getDeclaredFields();
        StringBuilder result = new StringBuilder();
        for (Field field : fields) {
            try {
                if (Modifier.isPrivate(field.getModifiers()) || field.get(this) == null) continue;
                result.append("  ");
                result.append(field.getName());
                result.append(": ");
                result.append(field.get(this));
            }
            catch (IllegalAccessException ex) {
                System.out.println(ex);
            }
            result.append(System.lineSeparator());
        }
        return result.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.status == 666) {
            super.printStackTrace(s);
        }
        s.println("Exception:");
        s.print(this.getRemoteStackTrace());
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.status == 666) {
            super.printStackTrace(s);
        }
        s.println("Exception:");
        s.print(this.getRemoteStackTrace());
    }

    public String getCode() {
        return this.code;
    }

    public String getException() {
        return this.exception;
    }

    public String getInfo() {
        return this.info;
    }
}

