/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.mail.actionpipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.mail.actionpipe.AbstractCaseManagementMailAction;
import org.nuxeo.cm.mail.actionpipe.MailActionPipeConstants;
import org.nuxeo.cm.mail.actionpipe.parser.DefaultEnglishMailParser;
import org.nuxeo.cm.mail.actionpipe.parser.DefaultFrenchMailParser;
import org.nuxeo.cm.mail.actionpipe.parser.GmailMailParser;
import org.nuxeo.cm.mail.actionpipe.parser.MailBodyParser;
import org.nuxeo.cm.mail.actionpipe.parser.ThunderbirdFrenchMailParser;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;

public class ParseMailBody
extends AbstractCaseManagementMailAction {
    private static final Log log = LogFactory.getLog(ParseMailBody.class);
    public static final Integer GROUP_TO_FIND_INDEX = 2;
    public static final Map<String, Integer> monthMap = new HashMap<String, Integer>();

    public static final void initializeMonthMap() {
        if (monthMap.isEmpty()) {
            monthMap.put("janvier", 0);
            monthMap.put("f\u00e9vrier", 1);
            monthMap.put("mars", 2);
            monthMap.put("avril", 3);
            monthMap.put("mai", 4);
            monthMap.put("juin", 5);
            monthMap.put("juillet", 6);
            monthMap.put("ao\u00fbt", 7);
            monthMap.put("septembre", 8);
            monthMap.put("octobre", 9);
            monthMap.put("novembre", 10);
            monthMap.put("d\u00e9cembre", 11);
        }
    }

    public boolean execute(ExecutionContext context) throws Exception {
        Object content = context.get((Object)"body");
        if (content != null) {
            ParseMailBody.parse(content, (Map<String, Object>)context);
        }
        return true;
    }

    public static void parse(Object content, Map<String, Object> resultMap) throws Exception {
        try {
            if (!(content instanceof String)) {
                log.error((Object)"Cannot parse non-string mail body");
                return;
            }
            String toParse = (String)content;
            log.debug((Object)("Trying to parse " + content));
            ArrayList<MailActionPipeConstants> mailBodyParsers = new ArrayList<MailActionPipeConstants>(2);
            mailBodyParsers.add(new DefaultEnglishMailParser());
            mailBodyParsers.add(new DefaultFrenchMailParser());
            mailBodyParsers.add(new ThunderbirdFrenchMailParser());
            mailBodyParsers.add(new GmailMailParser());
            MailBodyParser finalMailBodyParser = null;
            int startMatcher = Integer.MAX_VALUE;
            Matcher finalMatcher = null;
            for (MailBodyParser mailBodyParser : mailBodyParsers) {
                int start;
                Matcher matcher = mailBodyParser.getHeaderPattern().matcher(toParse);
                if (!matcher.matches() || (start = matcher.start(GROUP_TO_FIND_INDEX)) >= startMatcher) continue;
                startMatcher = start;
                finalMailBodyParser = mailBodyParser;
                finalMatcher = matcher;
            }
            if (finalMailBodyParser == null) {
                throw new IllegalArgumentException("Content cannot be matched : " + toParse);
            }
            finalMailBodyParser.parse(finalMatcher, resultMap);
        }
        catch (Exception e) {
            log.error((Object)"Cannot parse mail body", (Throwable)e);
        }
    }

    public void reset(ExecutionContext context) throws Exception {
    }
}

