/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.test;

import java.io.Serializable;
import java.util.UUID;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.storage.sql.TXSQLRepositoryTestCase;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class CaseManagementSecurityTestCase
extends TXSQLRepositoryTestCase {
    protected UserManager userManager;
    protected CaseDistributionService caseDistributionService;
    protected MailboxManagementService mailboxManagementService;
    protected static final String administrator = "Administrator";
    protected static final String user = "user";
    protected static final String user1 = "user1";
    protected static final String user2 = "user2";
    protected static final String user3 = "user3";
    protected static DocumentModel mailEnvelopeModel;
    protected Case envelope1;
    protected static DocumentModel mailEnvelopItemeModel;

    public CaseManagementSecurityTestCase() {
    }

    public CaseManagementSecurityTestCase(String name) {
    }

    protected void deployRepositoryContrib() throws Exception {
        super.deployRepositoryContrib();
        this.deployBundle("org.nuxeo.ecm.platform.search.api");
        this.deployBundle("org.nuxeo.ecm.platform.query.api");
        this.deployBundle("org.nuxeo.ecm.platform.classification.core");
        this.deployBundle("org.nuxeo.ecm.platform.routing.core");
        this.deployBundle("org.nuxeo.ecm.automation.core");
        this.deployBundle("org.nuxeo.cm.api");
        this.deployBundle("org.nuxeo.cm.core");
        this.deployBundle("org.nuxeo.ecm.directory");
        this.deployBundle("org.nuxeo.ecm.platform.usermanager");
        this.deployBundle("org.nuxeo.ecm.directory.types.contrib");
        this.deployBundle("org.nuxeo.ecm.directory.sql");
        this.deployBundle("org.nuxeo.cm.test");
        this.deployBundle("org.nuxeo.ecm.platform.content.template");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.userManager = (UserManager)Framework.getService(UserManager.class);
        CaseManagementSecurityTestCase.assertNotNull((Object)this.userManager);
        this.caseDistributionService = (CaseDistributionService)Framework.getService(CaseDistributionService.class);
        CaseManagementSecurityTestCase.assertNotNull((Object)this.caseDistributionService);
        this.mailboxManagementService = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
        CaseManagementSecurityTestCase.assertNotNull((Object)this.mailboxManagementService);
    }

    protected DocumentModel createDocument(String type, String id) throws Exception {
        DocumentModel document = this.session.createDocumentModel(type);
        document.setPathInfo("/", id);
        document = this.session.createDocument(document);
        return document;
    }

    public Case getMailEnvelope() throws Exception {
        DocumentModel model = this.getMailEnvelopeModel();
        DocumentModel doc = this.session.createDocument(model);
        this.session.saveDocument(doc);
        this.session.save();
        return (Case)doc.getAdapter(Case.class);
    }

    public DocumentModel getMailEnvelopeModel() throws Exception {
        CaseManagementDocumentTypeService correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        if (mailEnvelopeModel == null) {
            mailEnvelopeModel = this.session.createDocumentModel("/case-management/case-root", UUID.randomUUID().toString(), correspDocumentTypeService.getCaseType());
        }
        return mailEnvelopeModel;
    }

    public void createDraftPost(Mailbox mb, Case envelope) throws Exception {
        DocumentModel model = this.session.createDocumentModel(mb.getDocument().getPathAsString(), UUID.randomUUID().toString(), "CaseLink");
        DocumentModel doc = this.session.createDocument(model);
        doc.setPropertyValue("cslk:caseDocumentId", (Serializable)((Object)envelope.getDocument().getId()));
        doc.setPropertyValue("cslk:draft", (Serializable)Boolean.TRUE);
        doc.setPropertyValue("cslk:sender", (Serializable)((Object)mb.getId()));
        this.session.saveDocument(doc);
        this.session.save();
    }

    protected Mailbox createPersonalMailbox(String name) throws Exception {
        return (Mailbox)this.mailboxManagementService.createPersonalMailboxes(this.session, name).get(0);
    }

    protected CaseItem getMailEnvelopeItem() throws Exception {
        DocumentModel model = this.getMailEnvelopeItemModel();
        DocumentModel doc = this.session.createDocument(model);
        doc.setPropertyValue("dc:title", (Serializable)((Object)"title"));
        this.session.saveDocument(doc);
        this.session.save();
        return (CaseItem)doc.getAdapter(CaseItem.class);
    }

    protected DocumentModel getMailEnvelopeItemModel() throws Exception {
        if (mailEnvelopItemeModel == null) {
            mailEnvelopItemeModel = this.session.createDocumentModel("/", UUID.randomUUID().toString(), "IncomingCorrespondenceDocument");
        }
        return mailEnvelopItemeModel;
    }

    public Case createMailDocumentInEnvelope(Mailbox mailbox) throws Exception {
        DocumentModel emailDoc = this.getMailEnvelopeItemModel();
        this.session.save();
        Case envelope = this.caseDistributionService.createCase(this.session, emailDoc);
        this.caseDistributionService.createDraftCaseLink(this.session, mailbox, envelope);
        this.session.save();
        return envelope;
    }

    protected void setMailRootRigts() throws Exception {
        DocumentModel mailRootdoc = this.session.getDocument((DocumentRef)new PathRef("/case-management/case-root"));
        ACLImpl localACL = new ACLImpl("local");
        ACE ace = new ACE(user1, "Everything", true);
        localACL.add((Object)ace);
        ACP acp = mailRootdoc.getACP();
        acp.removeACL("local");
        acp.addACL((ACL)localACL);
        mailRootdoc.setACP(acp, true);
        this.session.save();
    }
}

