/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.test;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.service.CaseManagementDistributionTypeService;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.storage.sql.SQLRepositoryTestCase;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class CaseManagementRepositoryTestCase
extends SQLRepositoryTestCase {
    protected UserManager userManager;
    protected MailboxManagementService correspMailboxService;
    protected CaseDistributionService distributionService;
    protected CaseManagementDistributionTypeService correspDistributionTypeService;
    protected CaseManagementDocumentTypeService correspDocumentTypeService;
    protected static final String administrator = "Administrator";
    protected static final String user = "user";
    protected static final String user1 = "user1";
    protected static final String user2 = "user2";
    protected static final String user3 = "user3";
    protected static final String nulrich = "nulrich";
    protected static final String ldoguin = "ldoguin";
    public static final String CASE_TITLE = "moncase";
    public static final String DC_TITLE = "dc:title";
    protected static DocumentModel mailEnvelopeModel;
    protected static DocumentModel mailEnvelopeItemModel;
    protected Case envelope1;

    public CaseManagementRepositoryTestCase() {
    }

    public CaseManagementRepositoryTestCase(String name) {
    }

    protected void deployRepositoryContrib() throws Exception {
        super.deployRepositoryContrib();
        this.deployBundle("org.nuxeo.ecm.platform.search.api");
        this.deployBundle("org.nuxeo.ecm.platform.query.api");
        this.deployBundle("org.nuxeo.ecm.directory");
        this.deployBundle("org.nuxeo.ecm.platform.usermanager");
        this.deployBundle("org.nuxeo.ecm.directory.types.contrib");
        this.deployBundle("org.nuxeo.ecm.directory.sql");
        this.deployBundle("org.nuxeo.cm.test");
        this.deployBundle("org.nuxeo.ecm.platform.content.template");
        this.deployContrib("org.nuxeo.ecm.platform.routing.core", "OSGI-INF/document-routing-service.xml");
        this.deployContrib("org.nuxeo.ecm.platform.routing.core", "OSGI-INF/document-routing-core-types-contrib.xml");
        this.deployContrib("org.nuxeo.ecm.platform.routing.core", "OSGI-INF/document-routing-querymodel-contrib.xml");
        this.deployContrib("org.nuxeo.ecm.platform.classification.core", "OSGI-INF/classification-core-types-contrib.xml");
        this.deployBundle("org.nuxeo.cm.api");
        this.deployBundle("org.nuxeo.cm.core");
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fireFrameworkStarted();
        this.userManager = (UserManager)Framework.getService(UserManager.class);
        Assert.assertNotNull((Object)this.userManager);
        this.distributionService = (CaseDistributionService)Framework.getService(CaseDistributionService.class);
        Assert.assertNotNull((Object)this.distributionService);
        this.correspMailboxService = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
        Assert.assertNotNull((Object)this.correspMailboxService);
        this.correspDistributionTypeService = (CaseManagementDistributionTypeService)Framework.getService(CaseManagementDistributionTypeService.class);
        Assert.assertNotNull((Object)this.correspDistributionTypeService);
        this.correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        Assert.assertNotNull((Object)this.correspDocumentTypeService);
    }

    protected DocumentModel createDocument(String type, String id) throws Exception {
        DocumentModel document = this.session.createDocumentModel(type);
        document.setPathInfo("/", id);
        document = this.session.createDocument(document);
        return document;
    }

    public Case getMailEnvelope() throws Exception {
        DocumentModel model = this.getMailEnvelopeModel();
        model.setPropertyValue(DC_TITLE, (Serializable)((Object)CASE_TITLE));
        DocumentModel doc = this.session.createDocument(model);
        this.session.saveDocument(doc);
        this.session.save();
        return (Case)doc.getAdapter(Case.class);
    }

    public CaseItem getMailEnvelopeItem() throws Exception {
        DocumentModel model = this.getMailEnvelopeItemModel();
        DocumentModel doc = this.session.createDocument(model);
        this.session.saveDocument(doc);
        this.session.save();
        return (CaseItem)doc.getAdapter(CaseItem.class);
    }

    public DocumentModel getMailEnvelopeModel() throws Exception {
        CaseManagementDocumentTypeService correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        if (mailEnvelopeModel == null) {
            mailEnvelopeModel = this.session.createDocumentModel("/case-management/case-root", UUID.randomUUID().toString(), correspDocumentTypeService.getCaseType());
        }
        return mailEnvelopeModel;
    }

    public DocumentModel getMailEnvelopeItemModel() throws Exception {
        if (mailEnvelopeItemModel == null) {
            mailEnvelopeItemModel = this.session.createDocumentModel("/case-management/case-root", UUID.randomUUID().toString(), "CaseItem");
        }
        return mailEnvelopeItemModel;
    }

    public void createDraftPost(Mailbox mb, Case envelope) throws Exception {
        DocumentModel model = this.session.createDocumentModel(mb.getDocument().getPathAsString(), UUID.randomUUID().toString(), "CaseLink");
        DocumentModel doc = this.session.createDocument(model);
        doc.setPropertyValue("cslk:caseDocumentId", (Serializable)((Object)envelope.getDocument().getId()));
        doc.setPropertyValue("cslk:draft", (Serializable)Boolean.TRUE);
        doc.setPropertyValue("cslk:sender", (Serializable)((Object)mb.getId()));
        this.session.saveDocument(doc);
        this.session.save();
    }

    public Mailbox getPersonalMailbox(String name) throws Exception {
        return (Mailbox)this.correspMailboxService.createPersonalMailboxes(this.session, name).get(0);
    }

    public DocumentModel createDocumentModel(CoreSession session, String name, String type, String path) throws ClientException {
        DocumentModel route1 = session.createDocumentModel(path, name, type);
        route1.setPropertyValue(DC_TITLE, (Serializable)((Object)name));
        return session.createDocument(route1);
    }

    public DocumentRoute createComplexRoute(CoreSession session) throws Exception {
        this.createDocumentModel(session, "routes", "Folder", "/case-management");
        DocumentModel route = this.createDocumentModel(session, "route", "DocumentRoute", "/case-management/routes");
        DocumentModel step1 = this.createDocumentModel(session, "step1", "DistributionStep", route.getPathAsString());
        Mailbox user2Mailbox = this.getPersonalMailbox(user2);
        step1.setPropertyValue("rtsk:distributionMailboxId", (Serializable)((Object)user2Mailbox.getId()));
        session.saveDocument(step1);
        DocumentModel step2 = this.createDocumentModel(session, "step2", "DistributionTask", route.getPathAsString());
        step2.setPropertyValue("rtsk:distributionMailboxId", (Serializable)((Object)user2Mailbox.getId()));
        session.saveDocument(step2);
        DocumentModel parallelFolder1 = this.createDocumentModel(session, "parallelFolder1", "StepFolder", route.getPathAsString());
        parallelFolder1.setPropertyValue("stepf:execution", (Serializable)((Object)DocumentRoutingConstants.ExecutionTypeValues.parallel.name()));
        session.saveDocument(parallelFolder1);
        DocumentModel step31 = this.createDocumentModel(session, "step31", "DistributionTask", parallelFolder1.getPathAsString());
        step31.setPropertyValue("rtsk:distributionMailboxId", (Serializable)((Object)user2Mailbox.getId()));
        session.saveDocument(step31);
        DocumentModel step32 = this.createDocumentModel(session, "step32", "DistributionTask", parallelFolder1.getPathAsString());
        step32.setPropertyValue("rtsk:distributionMailboxId", (Serializable)((Object)user2Mailbox.getId()));
        session.saveDocument(step32);
        DocumentModel serialFolder = this.createDocumentModel(session, "serialFolder1", "StepFolder", parallelFolder1.getPathAsString());
        serialFolder.setPropertyValue("stepf:execution", (Serializable)((Object)DocumentRoutingConstants.ExecutionTypeValues.serial.name()));
        session.saveDocument(serialFolder);
        DocumentModel step41 = this.createDocumentModel(session, "step41", "DistributionTask", serialFolder.getPathAsString());
        step41.setPropertyValue("rtsk:distributionMailboxId", (Serializable)((Object)user2Mailbox.getId()));
        session.saveDocument(step41);
        DocumentModel step42 = this.createDocumentModel(session, "step42", "DistributionTask", serialFolder.getPathAsString());
        step42.setPropertyValue("rtsk:distributionMailboxId", (Serializable)((Object)user2Mailbox.getId()));
        step42.setPropertyValue("rtsk:dueDate", (Serializable)new Date());
        step42.setPropertyValue("rtsk:automaticValidation", (Serializable)Boolean.TRUE);
        session.saveDocument(step42);
        session.saveDocument(parallelFolder1);
        session.save();
        return (DocumentRoute)route.getAdapter(DocumentRoute.class);
    }
}

