/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.cases;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.web.distribution.CaseManagementDistributionActionsBean;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.mailbox.CaseManagementAbstractActionsBean;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="cmCaseActions")
@Scope(value=ScopeType.CONVERSATION)
@CaseManagementContextBound
@Install(precedence=10)
public class CaseManagementCaseActionsBean
extends CaseManagementAbstractActionsBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseManagementDistributionActionsBean.class);
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(required=true, create=true)
    protected NavigationContext navigationContext;

    public boolean isInitialCase() throws ClientException {
        Case env = this.getCurrentCase();
        if (env != null) {
            return this.getCurrentCase().isDraft();
        }
        return false;
    }

    public void removeCaseItem(DocumentModel doc) throws ClientException {
        Case currentEnvelope = this.getCurrentCase();
        CaseItem item = (CaseItem)doc.getAdapter(CaseItem.class);
        currentEnvelope.removeCaseItem(item, this.documentManager);
    }

    public DocumentRoutingService getDocumentRoutingService() {
        try {
            return (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    protected void resetCaseCache(Case cachedEnvelope, Case newEnvelope) throws ClientException {
        super.resetCaseCache(cachedEnvelope, newEnvelope);
    }

    public boolean isEmptyCase() throws ClientException {
        Case currentCase = this.getCurrentCase();
        if (currentCase != null) {
            return this.getCurrentCase().isEmpty();
        }
        return true;
    }
}

