/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.distribution;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.caselink.CaseLinkMode;
import org.nuxeo.cm.caselink.CaseLinkRequestImpl;
import org.nuxeo.cm.caselink.CaseLinkType;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.distribution.CMFDistributionInfo;
import org.nuxeo.cm.distribution.DistributionInfo;
import org.nuxeo.cm.distribution.ParticipantItem;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="cmDistributionActions")
@Install(precedence=10)
@Scope(value=ScopeType.CONVERSATION)
@CaseManagementContextBound
public class CaseManagementDistributionActionsBean
extends CaseManagementContextBoundInstance {
    public static final String DISTRIBUTION_ACTION_TABS_CATEGORY = "DISTRIBUTION_TABS";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseManagementDistributionActionsBean.class);
    @In(required=true, create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient CaseDistributionService caseDistributionService;
    @In(create=true)
    protected transient MailboxManagementService mailboxManagementService;
    @In(create=true)
    protected WebActions webActions;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    protected DistributionInfo distributionInfo;

    @Factory(value="distributionInfo", scope=ScopeType.EVENT)
    public DistributionInfo getDistributionInfo() throws ClientException {
        if (this.distributionInfo == null) {
            this.distributionInfo = new CMFDistributionInfo();
            List favs = null;
            Mailbox currentMailbox = this.getCurrentMailbox();
            if (currentMailbox != null) {
                favs = currentMailbox.getFavorites();
            }
            if (favs != null && !favs.isEmpty()) {
                ArrayList<ParticipantItem> favoriteMailboxes = new ArrayList<ParticipantItem>();
                for (String fav : favs) {
                    ParticipantItem item = (ParticipantItem)this.mailboxManagementService.getMailboxHeader(fav);
                    item.setMessageType(CaseLinkType.NONE.getStringType());
                    favoriteMailboxes.add(item);
                }
                this.distributionInfo.setFavoriteMailboxes(favoriteMailboxes);
            }
            this.distributionInfo.setMode(CaseLinkMode.ENTIRE_ENVELOPE.getStringType());
        }
        return this.distributionInfo;
    }

    public boolean validateDistributionParticipants() {
        if (!this.distributionInfo.hasParticipants()) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.distribution.noParticipants"), new Object[0]);
            return false;
        }
        return true;
    }

    public String validateWizard(DistributionInfo distributionInfo) throws ClientException {
        this.distributionInfo = distributionInfo;
        return this.validateWizard();
    }

    public String validateWizard() throws ClientException {
        DocumentModel envelopeDoc = null;
        if (this.distributionInfo != null) {
            if (!this.validateDistributionParticipants()) {
                return null;
            }
            CaseLinkMode mode = CaseLinkMode.valueOfString((String)this.distributionInfo.getMode());
            if (mode == null) {
                this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.distribution.invalidMode"), new Object[0]);
                return null;
            }
            Mailbox currentMailbox = this.getCurrentMailbox();
            if (currentMailbox == null) {
                this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.distribution.invalidCurrentMailbox"), new Object[0]);
                return null;
            }
            Case kase = this.getCurrentCase();
            if (mode == CaseLinkMode.ENTIRE_ENVELOPE) {
                envelopeDoc = kase.getDocument();
                DocumentModel emailDoc = kase.getFirstItem(this.documentManager).getDocument();
            } else if (mode == CaseLinkMode.DOC_ONLY) {
                DocumentModel emailDoc = this.getCurrentCaseItem();
                kase = this.caseDistributionService.createCaseFromExistingCaseItem((CaseItem)emailDoc.getAdapter(CaseItem.class), this.documentManager);
                DocumentModel parent = this.documentManager.getDocument(emailDoc.getParentRef());
                CaseItem item = (CaseItem)emailDoc.getAdapter(CaseItem.class);
                item.createMailCase(this.documentManager, parent.getPathAsString(), null);
                envelopeDoc = kase.getDocument();
            }
            if (kase == null || envelopeDoc == null) {
                this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.distribution.invalidCase"), new Object[0]);
                return null;
            }
            Map recipients = this.distributionInfo.getAllParticipants();
            CaseLinkRequestImpl postRequest = new CaseLinkRequestImpl(currentMailbox.getId(), Calendar.getInstance(), (String)((Object)envelopeDoc.getPropertyValue("dc:title")), this.distributionInfo.getComment(), kase, recipients, null);
            this.caseDistributionService.sendCase(this.documentManager, (CaseLink)postRequest, kase.isDraft());
            if (recipients.isEmpty()) {
                this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.corresp.distribution.noFinalRecipients"), new Object[0]);
                return null;
            }
            kase.save(this.documentManager);
            this.documentManager.save();
            this.resetWizard();
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.distribution.done"), new Object[0]);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentMailbox.getDocument()});
        }
        this.webActions.resetCurrentTab();
        return this.navigationContext.navigateToDocument(envelopeDoc);
    }

    public boolean canDistributeCase() throws ClientException {
        Case kase = this.getCurrentCase();
        if (kase == null) {
            return false;
        }
        if (kase.isEmpty()) {
            return false;
        }
        List links = this.caseDistributionService.getCaseLinks(this.documentManager, null, kase);
        return !links.isEmpty();
    }

    public String cancelWizard() throws ClientException {
        this.resetWizard();
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.navigationContext.navigateToDocument(currentDoc);
    }

    public void resetWizard() {
        this.distributionInfo = null;
    }

    @Override
    protected void resetCurrentCaseItemCache(DocumentModel cachedEmail, DocumentModel newEmail) throws ClientException {
        this.resetWizard();
    }

    @Override
    protected void resetCaseCache(Case cachedEnvelope, Case newEnvelope) throws ClientException {
        this.resetWizard();
    }
}

