/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.invalidations;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.nuxeo.cm.web.context.CaseManagementContextHolder;
import org.nuxeo.cm.web.invalidations.CaseManagementContextChecker;

@Interceptor(stateless=true, within={BijectionInterceptor.class})
public class CaseManagementContextInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseManagementContextInterceptor.class);

    public Object aroundInvoke(InvocationContext invocationContext) throws Exception {
        this.beforeInvocation(invocationContext);
        return invocationContext.proceed();
    }

    protected void beforeInvocation(InvocationContext invocationContext) {
        Object target = invocationContext.getTarget();
        for (Method meth : target.getClass().getMethods()) {
            if (!meth.isAnnotationPresent(CaseManagementContextChecker.class)) continue;
            try {
                meth.invoke(target, this.getCaseManagementContextHolder());
            }
            catch (Exception e) {
                log.error((Object)"Error during Invalidation method call", (Throwable)e);
            }
        }
    }

    protected CaseManagementContextHolder getCaseManagementContextHolder() {
        return (CaseManagementContextHolder)Component.getInstance((String)"cmContextHolder", (ScopeType)ScopeType.CONVERSATION);
    }
}

