/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.caseitem;

import java.io.Serializable;
import java.util.Collections;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.cases.LockableAdapter;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.web.caseitem.CaseManagementDocumentActions;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.preview.seam.PreviewActionBean;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.webapp.action.TypesTool;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="cmDocumentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
@CaseManagementContextBound
public class CaseItemDocumentActionsBean
extends CaseManagementContextBoundInstance
implements CaseManagementDocumentActions {
    private static final String DOCUMENT_SAVED = "document_saved";
    private static final String DOCUMENT_MODIFIED = "document_modified";
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected TypeManager typeManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient CaseDistributionService caseDistributionService;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient PreviewActionBean previewActions;
    @In(create=true)
    protected TypesTool typesTool;
    protected Boolean editingMail = false;

    public String createDocument(String typeName) throws ClientException {
        Type docType = this.typeManager.getType(typeName);
        this.typesTool.setSelectedType(docType);
        try {
            DocumentModel changeableDocument = this.documentManager.createDocumentModel(typeName);
            changeableDocument.putContextData("createNewCaseKey", (Serializable)Boolean.valueOf(true));
            this.navigationContext.setChangeableDocument(changeableDocument);
            return this.navigationContext.getActionResult(changeableDocument, UserAction.CREATE);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String createCaseItemInCase() throws ClientException {
        DocumentModel emailDoc = this.navigationContext.getChangeableDocument();
        Case kase = this.getCurrentCase();
        if (kase != null && emailDoc.getContextData("createNewCaseKey") == null) {
            CaseItem newCaseItem = this.caseDistributionService.addCaseItemToCase(this.documentManager, kase, emailDoc);
            emailDoc = newCaseItem.getDocument();
            emailDoc.setProperty("case_item", "defaultCaseId", (Object)this.getCurrentCase().getDocument().getId());
            this.documentManager.saveDocument(emailDoc);
            TypeInfo typeInfo = (TypeInfo)kase.getDocument().getAdapter(TypeInfo.class);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.documentManager.getDocument(emailDoc.getRef())});
            return typeInfo.getDefaultView();
        }
        Mailbox currentMailbox = this.getCurrentMailbox();
        Case envelope = this.caseDistributionService.createCase(this.documentManager, emailDoc, Collections.singletonList(currentMailbox));
        emailDoc = envelope.getFirstItem(this.documentManager).getDocument();
        emailDoc.setProperty("case_item", "defaultCaseId", (Object)envelope.getDocument().getId());
        this.documentManager.saveDocument(emailDoc);
        this.caseDistributionService.createDraftCaseLink(this.documentManager, this.getCurrentMailbox(), envelope);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.documentManager.getDocument(currentMailbox.getDocument().getRef())});
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(DOCUMENT_SAVED), new Object[]{this.resourcesAccessor.getMessages().get(emailDoc.getType())});
        DocumentModel envelopeDocModel = envelope.getDocument();
        this.navigationContext.navigateToDocument(envelopeDocModel);
        TypeInfo typeInfo = (TypeInfo)envelopeDocModel.getAdapter(TypeInfo.class);
        return typeInfo.getDefaultView();
    }

    public String createEmptyCase() throws ClientException {
        DocumentModel caseDoc = this.navigationContext.getChangeableDocument();
        Mailbox currentMailbox = this.getCurrentMailbox();
        Case emptyCase = this.caseDistributionService.createEmptyCase(this.documentManager, caseDoc, currentMailbox);
        this.caseDistributionService.createDraftCaseLink(this.documentManager, this.getCurrentMailbox(), emptyCase);
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(DOCUMENT_SAVED), new Object[]{this.resourcesAccessor.getMessages().get(caseDoc.getType())});
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.documentManager.getDocument(currentMailbox.getDocument().getRef())});
        caseDoc = emptyCase.getDocument();
        this.navigationContext.setCurrentDocument(caseDoc);
        TypeInfo typeInfo = (TypeInfo)caseDoc.getAdapter(TypeInfo.class);
        return typeInfo.getDefaultView();
    }

    protected DocumentModel getParentFolder() throws ClientException {
        return this.caseDistributionService.getParentDocumentForCase(this.documentManager);
    }

    @Override
    public boolean getCanEditCurrentDocument() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc == null) {
            return false;
        }
        LockableAdapter lockableMail = (LockableAdapter)currentDoc.getAdapter(LockableAdapter.class);
        if (lockableMail.isLocked(this.documentManager)) {
            return false;
        }
        return this.documentManager.hasPermission(currentDoc.getRef(), "Write");
    }

    @Override
    public boolean getCanEditCurrentCaseItem() throws ClientException {
        DocumentModel currentEmail = this.getCurrentCaseItem();
        if (currentEmail == null) {
            return false;
        }
        LockableAdapter lockableMail = (LockableAdapter)currentEmail.getAdapter(LockableAdapter.class);
        if (lockableMail.isLocked(this.documentManager)) {
            return false;
        }
        return this.documentManager.hasPermission(currentEmail.getRef(), "Write");
    }

    @Override
    public void updateCurrentCaseItem() throws ClientException {
        DocumentModel currentEmailDoc = this.getCurrentCaseItem();
        CaseItem currentEmail = (CaseItem)currentEmailDoc.getAdapter(CaseItem.class);
        currentEmail.save(this.documentManager);
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(DOCUMENT_MODIFIED), new Object[]{this.resourcesAccessor.getMessages().get(currentEmail.getType())});
        EventManager.raiseEventsOnDocumentChange((DocumentModel)currentEmail.getDocument());
    }

    public boolean isCurrentCaseItemPreviewAvailable() throws ClientException {
        if (this.getCurrentCase() == null || this.getCurrentCase().isEmpty()) {
            return false;
        }
        DocumentModel currentEmail = this.getCurrentCaseItem();
        if (currentEmail != null) {
            return this.previewActions.documentHasPreview(currentEmail);
        }
        return false;
    }

    public boolean isEditingCaseItem() throws ClientException {
        DocumentModel caseItem = this.getCurrentCaseItem();
        if (caseItem == null) {
            return false;
        }
        LockableAdapter lockable = (LockableAdapter)caseItem.getAdapter(LockableAdapter.class);
        if (lockable.isLockedByCurrentUser(this.documentManager)) {
            return true;
        }
        return this.editingMail;
    }

    public void startEditingCaseItem() throws ClientException {
        LockableAdapter lockable = (LockableAdapter)this.getCurrentCaseItem().getAdapter(LockableAdapter.class);
        if (this.documentManager.hasPermission(this.getCurrentCaseItem().getRef(), "Write")) {
            if (!lockable.isLockedByCurrentUser(this.documentManager)) {
                lockable.lockDocument(this.documentManager);
            }
            this.editingMail = true;
        }
    }

    public void quitEditingMail() throws ClientException {
        this.editingMail = false;
        LockableAdapter lockable = (LockableAdapter)this.getCurrentCaseItem().getAdapter(LockableAdapter.class);
        if (lockable.isLockedByCurrentUser(this.documentManager)) {
            lockable.unlockDocument(this.documentManager);
        }
    }

    @Override
    public String getCaseItemLayoutMode() throws ClientException {
        DocumentModel currentEmail;
        DocumentRef currentEmailRef;
        String mode = "view";
        if (this.isEditingCaseItem() && this.documentManager.hasPermission(currentEmailRef = (currentEmail = this.getCurrentCaseItem()).getRef(), "Write")) {
            mode = "edit";
        }
        return mode;
    }

    public String backToMailbox() throws ClientException {
        this.quitEditingMail();
        return this.returnToDocView();
    }

    protected String returnToDocView() throws ClientException {
        DocumentModel doc = this.getCurrentCase().getDocument();
        TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
        return typeInfo.getDefaultView();
    }

    public String save() throws ClientException {
        this.quitEditingMail();
        this.updateCurrentCaseItem();
        return this.returnToDocView();
    }

    @Override
    protected void resetCurrentCaseItemCache(DocumentModel cachedEmail, DocumentModel newEmail) throws ClientException {
        this.editingMail = false;
    }
}

