/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.cases;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.caselink.CaseLinkRequestImpl;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.cases.LockableAdapter;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.web.distribution.CaseManagementDistributionActionsBean;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="cmCaseActions")
@Scope(value=ScopeType.CONVERSATION)
@CaseManagementContextBound
@Install(precedence=10)
public class CaseManagementCaseActionsBean
extends CaseManagementContextBoundInstance {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseManagementDistributionActionsBean.class);
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(required=true, create=true)
    protected WebActions webActions;
    @In(required=true, create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient CaseDistributionService caseDistributionService;
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    protected transient TrashService trashService;

    public boolean isInitialCase() throws ClientException {
        Case env = this.getCurrentCase();
        if (env != null) {
            return this.getCurrentCase().isDraft();
        }
        return false;
    }

    public void removeCaseItem(DocumentModel doc) throws ClientException {
        Case currentEnvelope = this.getCurrentCase();
        CaseItem item = (CaseItem)doc.getAdapter(CaseItem.class);
        currentEnvelope.removeCaseItem(item, this.documentManager);
    }

    public DocumentRoutingService getDocumentRoutingService() {
        try {
            return (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    protected void resetCaseCache(Case cachedEnvelope, Case newEnvelope) throws ClientException {
        super.resetCaseCache(cachedEnvelope, newEnvelope);
    }

    public boolean isEmptyCase() throws ClientException {
        Case currentCase = this.getCurrentCase();
        if (currentCase != null) {
            return this.getCurrentCase().isEmpty();
        }
        return true;
    }

    public String markAsSent() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            List workingList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            CaseLink post = null;
            DocumentModel parentDoc = null;
            Mailbox parentMailbox = null;
            Case envelope = null;
            CaseLinkRequestImpl postRequest = null;
            for (DocumentModel documentModel : workingList) {
                post = (CaseLink)documentModel.getAdapter(CaseLink.class);
                parentDoc = this.documentManager.getParentDocument(post.getDocument().getRef());
                parentMailbox = (Mailbox)parentDoc.getAdapter(Mailbox.class);
                envelope = post.getCase(this.documentManager);
                postRequest = new CaseLinkRequestImpl(parentMailbox.getId(), post.getDate(), (String)((Object)envelope.getDocument().getPropertyValue("dc:title")), post.getComment(), envelope, post.getInitialInternalParticipants(), post.getInitialExternalParticipants());
                this.caseDistributionService.sendCase(this.documentManager, (CaseLink)postRequest, true);
                EventManager.raiseEventsOnDocumentChildrenChange((DocumentModel)parentDoc);
            }
        }
        return null;
    }

    public String purgeCaseSelection() throws ClientException {
        if (!this.isEmptyDraft()) {
            List currentDraftCasesList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            this.purgeCaseSelection(currentDraftCasesList);
            EventManager.raiseEventsOnDocumentChildrenChange((DocumentModel)this.getCurrentMailbox().getDocument());
            this.documentsListsManager.resetWorkingList("CURRENT_SELECTION");
        } else {
            log.debug((Object)"No documents selection in context to process delete on...");
        }
        return null;
    }

    public boolean isEmptyDraft() {
        return this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION");
    }

    public boolean getCanPurge() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (docs.isEmpty()) {
            return false;
        }
        try {
            return this.getTrashService().canDelete(docs, this.documentManager.getPrincipal(), false);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException("Cannot check delete permission", (Throwable)e);
        }
    }

    protected void purgeCaseSelection(List<DocumentModel> workingList) throws ClientException {
        final ArrayList<DocumentRef> caseRefs = new ArrayList<DocumentRef>();
        final ArrayList<DocumentRef> postRefs = new ArrayList<DocumentRef>();
        for (DocumentModel documentModel : workingList) {
            CaseLink caselink = (CaseLink)documentModel.getAdapter(CaseLink.class);
            try {
                caseRefs.add(caselink.getCase(this.documentManager).getDocument().getRef());
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            postRefs.add(documentModel.getRef());
        }
        DocumentRef currentDocRef = this.navigationContext.getCurrentDocument().getRef();
        boolean containsSelectedDocument = false;
        if (caseRefs.contains(currentDocRef)) {
            containsSelectedDocument = true;
        }
        block3: for (DocumentRef caseRef : caseRefs) {
            if (containsSelectedDocument) break;
            List items = ((Case)this.documentManager.getDocument(caseRef).getAdapter(Case.class)).getCaseItems(this.documentManager);
            for (CaseItem caseItem : items) {
                if (!currentDocRef.equals(caseItem.getDocument().getRef())) continue;
                containsSelectedDocument = true;
                continue block3;
            }
        }
        new UnrestrictedSessionRunner(this.documentManager){

            public void run() throws ClientException {
                CaseManagementCaseActionsBean.this.getTrashService().purgeDocuments(this.session, caseRefs);
                CaseManagementCaseActionsBean.this.getTrashService().purgeDocuments(this.session, postRefs);
            }
        }.runUnrestricted();
        if (containsSelectedDocument) {
            this.navigationContext.setCurrentDocument(this.getCurrentMailbox().getDocument());
        }
    }

    protected TrashService getTrashService() {
        if (this.trashService == null) {
            try {
                this.trashService = (TrashService)Framework.getService(TrashService.class);
            }
            catch (Exception e) {
                throw new RuntimeException("TrashService not available", e);
            }
        }
        return this.trashService;
    }

    public Boolean getCanEditCurrentCase() throws ClientException {
        Case currentCase = this.getCurrentCase();
        if (currentCase == null) {
            return false;
        }
        DocumentModel caseDoc = currentCase.getDocument();
        if (caseDoc == null) {
            return false;
        }
        LockableAdapter lockableCase = (LockableAdapter)caseDoc.getAdapter(LockableAdapter.class);
        if (lockableCase.isLocked(this.documentManager)) {
            return false;
        }
        if (this.documentManager.hasPermission(caseDoc.getRef(), "Write")) {
            return true;
        }
        return false;
    }

    public Boolean canCaseSelectionFollowTransition(String transition) {
        if (!this.isEmptyDraft()) {
            List currentDraftCasesList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            for (DocumentModel documentModel : currentDraftCasesList) {
                CaseLink caselink = (CaseLink)documentModel.getAdapter(CaseLink.class);
                Case kase = caselink.getCase(this.documentManager);
                if (kase.canFollowTransition(transition)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String followTranstionCaseSelection(String transition) throws ClientException {
        if (!this.isEmptyDraft()) {
            List currentDraftCasesList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            for (DocumentModel documentModel : currentDraftCasesList) {
                CaseLink caselink = (CaseLink)documentModel.getAdapter(CaseLink.class);
                Case kase = caselink.getCase(this.documentManager);
                kase.followTransition(transition);
            }
            EventManager.raiseEventsOnDocumentChildrenChange((DocumentModel)this.getCurrentMailbox().getDocument());
            this.webActions.resetTabList();
        } else {
            log.debug((Object)"No documents selection in context to process delete on...");
        }
        return null;
    }
}

