/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.contentbrowser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeActionsBean;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="treeActions")
@Install(precedence=20)
public class CaseTreeActionsBean
extends TreeActionsBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseTreeActionsBean.class);

    public List<DocumentTreeNode> getCaseTreeRoots(String treeName, DocumentModel currentDocument) throws ClientException {
        ArrayList<DocumentTreeNodeImpl> currentTree;
        if (this.treeInvalidator.needsInvalidation()) {
            this.reset();
            this.treeInvalidator.invalidationDone();
        }
        if ((currentTree = (ArrayList<DocumentTreeNodeImpl>)this.trees.get(treeName)) == null) {
            currentTree = new ArrayList<DocumentTreeNodeImpl>();
            DocumentModel firstAccessibleParent = null;
            if (currentDocument != null) {
                firstAccessibleParent = currentDocument;
            }
            if (firstAccessibleParent != null) {
                Filter filter = null;
                Filter leafFilter = null;
                Sorter sorter = null;
                String pageProvider = null;
                QueryModel queryModel = null;
                QueryModel orderableQueryModel = null;
                try {
                    TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
                    filter = treeManager.getFilter(treeName);
                    leafFilter = treeManager.getLeafFilter(treeName);
                    sorter = treeManager.getSorter(treeName);
                    pageProvider = treeManager.getPageProviderName(treeName);
                    QueryModelDescriptor queryModelDescriptor = treeManager.getQueryModelDescriptor(treeName);
                    queryModel = queryModelDescriptor == null ? null : new QueryModel(queryModelDescriptor);
                    QueryModelDescriptor orderableQueryModelDescriptor = treeManager.getOrderableQueryModelDescriptor(treeName);
                    orderableQueryModel = orderableQueryModelDescriptor == null ? null : new QueryModel(orderableQueryModelDescriptor);
                }
                catch (Exception e) {
                    log.error((Object)"Could not fetch filter or sorter for tree ", (Throwable)e);
                }
                DocumentTreeNodeImpl treeRoot = null;
                treeRoot = pageProvider == null ? new DocumentTreeNodeImpl(this.documentManager.getSessionId(), firstAccessibleParent, filter, leafFilter, sorter, queryModel, orderableQueryModel) : new DocumentTreeNodeImpl(this.documentManager.getSessionId(), firstAccessibleParent, filter, leafFilter, sorter, pageProvider);
                currentTree.add(treeRoot);
                log.debug((Object)("Tree initialized with document: " + firstAccessibleParent.getId()));
            } else {
                log.debug((Object)"Could not initialize the navigation tree: no parent found for current document");
            }
            this.trees.put(treeName, currentTree);
        }
        return (List)this.trees.get(treeName);
    }
}

