/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.mailbox;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.web.context.CaseManagementContextHolderBean;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;

@Name(value="cmMailboxTabsActionsBean")
@Scope(value=ScopeType.CONVERSATION)
@CaseManagementContextBound
public class CaseManagementMailboxTabsActionsBean
extends CaseManagementContextBoundInstance {
    private static final long serialVersionUID = 1L;
    protected List<Action> viewMailboxActionTabs;
    protected Action currentViewMailboxAction;
    protected List<Action> manageMailboxActionTabs;
    protected Action currentManageMailboxAction;
    protected List<Action> distributionEnvelopeActionTabs;
    protected Action currentDistributionEnvelopeAction;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected CaseManagementContextHolderBean cmContextHolder;
    @In(required=true, create=true)
    protected transient ActionManager actionManager;
    @In(create=true, required=false)
    protected transient WebActions webActions;
    private static final Log log = LogFactory.getLog(CaseManagementMailboxTabsActionsBean.class);

    @Factory(value="viewMailboxActionTabs", scope=ScopeType.EVENT)
    public List<Action> getViewMailboxActionTabs() {
        if (this.viewMailboxActionTabs == null) {
            this.viewMailboxActionTabs = this.webActions.getActionsList("VIEW_MAILBOX_ACTION_LIST");
        }
        return this.viewMailboxActionTabs;
    }

    @Factory(value="manageMailboxActionTabs", scope=ScopeType.EVENT)
    public List<Action> getManageMailboxActionTabs() {
        if (this.manageMailboxActionTabs == null) {
            this.manageMailboxActionTabs = this.webActions.getActionsList("MANAGE_MAILBOX_ACTION_LIST");
        }
        return this.manageMailboxActionTabs;
    }

    @Factory(value="distributionCaseActionTabs", scope=ScopeType.EVENT)
    public List<Action> getDistributionCaseActionTabs() {
        if (this.distributionEnvelopeActionTabs == null) {
            this.distributionEnvelopeActionTabs = this.webActions.getActionsList("DISTRIBUTION_CASE_ACTION_LIST");
        }
        return this.distributionEnvelopeActionTabs;
    }

    @Factory(value="currentViewMailboxAction", scope=ScopeType.EVENT)
    public Action getCurrentViewMailboxAction() {
        List<Action> actions;
        if (this.currentViewMailboxAction == null && (actions = this.getViewMailboxActionTabs()) != null && !actions.isEmpty()) {
            this.currentViewMailboxAction = actions.get(0);
        }
        return this.currentViewMailboxAction;
    }

    @Factory(value="currentDistributionCaseAction", scope=ScopeType.EVENT)
    public Action getCurrentDistributionCaseAction() {
        List<Action> actions;
        if (this.currentDistributionEnvelopeAction == null && (actions = this.getDistributionCaseActionTabs()) != null && !actions.isEmpty()) {
            this.currentDistributionEnvelopeAction = actions.get(0);
        }
        return this.currentDistributionEnvelopeAction;
    }

    @Factory(value="currentManageMailboxAction", scope=ScopeType.EVENT)
    public Action getCurrentManageMailboxAction() {
        List<Action> actions;
        if (this.currentManageMailboxAction == null && (actions = this.getManageMailboxActionTabs()) != null && !actions.isEmpty()) {
            this.currentManageMailboxAction = actions.get(0);
        }
        return this.currentManageMailboxAction;
    }

    public void setCurrentViewMailboxAction(String actionId) throws ClientException {
        String previous = this.getCurrentViewMailboxAction().getId();
        if (!actionId.equals(previous)) {
            Contexts.removeFromAllContexts((String)"currentCase");
            Contexts.removeFromAllContexts((String)"currentCaseItem");
            this.navigationContext.setCurrentDocument(this.getCurrentMailbox().getDocument());
            this.cmContextHolder.setCurrentCase(null);
            this.cmContextHolder.setCurrentCaseItem(null);
        }
        Action target = this.actionManager.getAction(actionId);
        List<Action> actions = this.getViewMailboxActionTabs();
        if (actions != null && !actions.isEmpty() && actions.contains(target)) {
            this.currentViewMailboxAction = target;
        }
    }

    public void setCurrentManageMailboxAction(String actionId) throws ClientException {
        Action target = this.actionManager.getAction(actionId);
        List<Action> actions = this.getManageMailboxActionTabs();
        if (actions != null && !actions.isEmpty() && actions.contains(target)) {
            this.currentManageMailboxAction = target;
        }
    }

    public void setCurrentDistributionCaseAction(String actionId) throws ClientException {
        Action target = this.actionManager.getAction(actionId);
        List<Action> actions = this.getDistributionCaseActionTabs();
        if (actions != null && !actions.isEmpty() && actions.contains(target)) {
            this.currentDistributionEnvelopeAction = target;
        }
    }

    public String openMailboxManage() {
        this.currentManageMailboxAction = null;
        return "mailbox_manage";
    }

    public String openMailboxView() {
        this.currentViewMailboxAction = null;
        return "mailbox_view";
    }

    @Override
    protected void resetMailboxCache(Mailbox cachedMailbox, Mailbox newMailbox) throws ClientException {
        this.viewMailboxActionTabs = null;
        this.distributionEnvelopeActionTabs = null;
    }
}

