/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.routing;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="cmRoutingActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
@CaseManagementContextBound
public class CaseManagementRoutingActionsBean
extends CaseManagementContextBoundInstance {
    private static final String QUERY_ACTIONNABLE_CASE_LINK_FROM_CASE = "SELECT * FROM CaseLink WHERE cslk:isActionable = 1 AND cslk:caseDocumentId = %s";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseManagementRoutingActionsBean.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(required=true, create=true)
    protected NavigationContext navigationContext;
    @In(required=true, create=true)
    protected WebActions webActions;

    public String navigateToRouteTab(DocumentModel routeDoc) throws ClientException {
        String view = this.navigationContext.navigateToDocument(routeDoc, "view_documents");
        this.webActions.setCurrentTabId("TAB_DOCUMENT_ROUTE_ELEMENTS");
        return view;
    }

    public List<DocumentRoute> getCurrentDocumentLinkedRoute() throws Exception {
        List<Object> routes = new LinkedList<DocumentRoute>();
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc == null) {
            return routes;
        }
        ArrayList<DocumentRouteElement.ElementLifeCycleState> states = new ArrayList<DocumentRouteElement.ElementLifeCycleState>();
        states.add(DocumentRouteElement.ElementLifeCycleState.ready);
        states.add(DocumentRouteElement.ElementLifeCycleState.running);
        states.add(DocumentRouteElement.ElementLifeCycleState.done);
        routes = this.getDocumentRoutingService().getDocumentRoutesForAttachedDocument(this.documentManager, currentDoc.getId(), states);
        return routes;
    }

    public DocumentRoutingService getDocumentRoutingService() {
        try {
            return (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public DocumentModelList getPendingActionnableClsk(DocumentModel caseDoc) throws ClientException {
        String query = String.format(QUERY_ACTIONNABLE_CASE_LINK_FROM_CASE, caseDoc.getId());
        DocumentModelList pendingAClsk = this.documentManager.query(query);
        return pendingAClsk;
    }
}

