/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.context;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.web.context.CaseManagementContextActions;
import org.nuxeo.cm.web.context.CaseManagementContextHolderBean;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.tree.TreeActions;

@Name(value="cmContextActions")
@Scope(value=ScopeType.CONVERSATION)
public class CaseManagementContextActionsBean
implements Serializable,
CaseManagementContextActions {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CaseManagementContextHolderBean cmContextHolder;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient TreeActions treeActions;
    @In(create=true)
    protected NavigationContext navigationContext;

    @Override
    public String getCurrentCaseItemId() throws ClientException {
        DocumentModel currentEmail = this.cmContextHolder.getCurrentCaseItem();
        if (currentEmail != null) {
            return currentEmail.getId();
        }
        return null;
    }

    @Override
    public void setCurrentCaseItemId(String id) throws ClientException {
        DocumentModel currentEmail;
        if (id != null && this.documentManager != null && !"".equals(id = id.trim()) && (currentEmail = this.documentManager.getDocument((DocumentRef)new IdRef(id))) != null) {
            this.cmContextHolder.setCurrentCaseItem(currentEmail);
        }
    }

    @Override
    @Observer(value={"documentSelectionChanged"}, create=true)
    public void currentDocumentChanged(DocumentModel newDocument) {
        if (newDocument != null) {
            if (newDocument.hasFacet("Mailbox")) {
                this.cmContextHolder.setCurrentMailbox((Mailbox)newDocument.getAdapter(Mailbox.class));
            }
            if (newDocument.hasFacet("Distributable") && !newDocument.hasFacet("CaseGroupable")) {
                this.cmContextHolder.setCurrentCase((Case)newDocument.getAdapter(Case.class));
                this.cmContextHolder.setCurrentCaseItem(null);
                this.treeActions.reset();
            } else if (newDocument.hasFacet("Distributable") && newDocument.hasFacet("CaseGroupable")) {
                this.cmContextHolder.setCurrentCaseItem(newDocument);
            } else if (newDocument.hasSchema("classification")) {
                this.cmContextHolder.setCurrentCase(null);
                this.cmContextHolder.setCurrentCaseItem(null);
            }
        }
    }

    public boolean currentDocumentIsDistributable() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc == null) {
            return false;
        }
        return currentDoc.hasFacet("Distributable");
    }
}

