/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.relations;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.ecm.platform.relations.web.NodeInfo;
import org.nuxeo.ecm.platform.relations.web.NodeInfoImpl;
import org.nuxeo.ecm.platform.relations.web.StatementInfo;
import org.nuxeo.ecm.platform.relations.web.StatementInfoComparator;
import org.nuxeo.ecm.platform.relations.web.StatementInfoImpl;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="cmRelationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
@CaseManagementContextBound
public class CaseManagementRelationActionsBean
extends CaseManagementContextBoundInstance {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseManagementRelationActionsBean.class);
    public static final String CURRENT_CASE_ITEM_RELATION_SEARCH_QUERYMODEL = "CURRENT_CASE_ITEM_RELATION_SEARCH";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected RelationManager relationManager;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected transient QueryModelActions queryModelActions;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(required=false)
    protected transient Principal currentUser;
    protected List<Statement> incomingStatements;
    protected List<StatementInfo> incomingStatementsInfo;
    protected List<Statement> outgoingStatements;
    protected List<StatementInfo> outgoingStatementsInfo;
    protected Boolean showCreateForm = false;
    protected String predicateUri;
    protected String comment;
    protected String searchKeywords;
    protected List<String> targetCreationDocuments;

    public DocumentModel getDocumentModel(Node node) throws ClientException {
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)node;
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("CoreSession", this.documentManager.getSessionId());
            Serializable o = this.relationManager.getResourceRepresentation(resource.getNamespace(), (Resource)resource, context);
            if (o instanceof DocumentModel) {
                return (DocumentModel)o;
            }
        }
        return null;
    }

    public QNameResource getDocumentResource(DocumentModel document) throws ClientException {
        QNameResource documentResource = null;
        if (document != null) {
            documentResource = (QNameResource)this.relationManager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)document, null);
        }
        return documentResource;
    }

    protected List<StatementInfo> getStatementsInfo(List<Statement> statements) throws ClientException {
        if (statements == null) {
            return null;
        }
        ArrayList<StatementInfo> infoList = new ArrayList<StatementInfo>();
        for (Statement statement : statements) {
            Subject subject = statement.getSubject();
            NodeInfoImpl subjectInfo = new NodeInfoImpl((Node)subject, this.getDocumentModel((Node)subject), true);
            Resource predicate = statement.getPredicate();
            Node object = statement.getObject();
            NodeInfoImpl objectInfo = new NodeInfoImpl(object, this.getDocumentModel(object), true);
            StatementInfoImpl info = new StatementInfoImpl(statement, (NodeInfo)subjectInfo, (NodeInfo)new NodeInfoImpl((Node)predicate), (NodeInfo)objectInfo);
            infoList.add((StatementInfo)info);
        }
        return infoList;
    }

    public List<StatementInfo> getIncomingStatementsInfo() throws ClientException {
        if (this.incomingStatementsInfo != null) {
            return this.incomingStatementsInfo;
        }
        DocumentModel currentDoc = this.getCurrentCaseItem();
        QNameResource docResource = this.getDocumentResource(currentDoc);
        if (docResource == null) {
            this.incomingStatements = Collections.emptyList();
            this.incomingStatementsInfo = Collections.emptyList();
        } else {
            StatementImpl pattern = new StatementImpl(null, null, (Node)docResource);
            this.incomingStatements = this.relationManager.getStatements("default", (Statement)pattern);
            this.incomingStatementsInfo = this.getStatementsInfo(this.incomingStatements);
            Comparator comp = Collections.reverseOrder(new StatementInfoComparator());
            Collections.sort(this.incomingStatementsInfo, comp);
        }
        return this.incomingStatementsInfo;
    }

    public SelectDataModel getIncomingStatementsInfoSelectModel() throws ClientException {
        return new SelectDataModelImpl("cm_incoming_relations", this.getIncomingStatementsInfo(), null);
    }

    public List<StatementInfo> getOutgoingStatementsInfo() throws ClientException {
        if (this.outgoingStatementsInfo != null) {
            return this.outgoingStatementsInfo;
        }
        DocumentModel currentDoc = this.getCurrentCaseItem();
        QNameResource docResource = this.getDocumentResource(currentDoc);
        if (docResource == null) {
            this.outgoingStatements = Collections.emptyList();
            this.outgoingStatementsInfo = Collections.emptyList();
        } else {
            StatementImpl pattern = new StatementImpl((Node)docResource, null, null);
            this.outgoingStatements = this.relationManager.getStatements("default", (Statement)pattern);
            this.outgoingStatementsInfo = this.getStatementsInfo(this.outgoingStatements);
            Comparator comp = Collections.reverseOrder(new StatementInfoComparator());
            Collections.sort(this.outgoingStatementsInfo, comp);
        }
        return this.outgoingStatementsInfo;
    }

    public SelectDataModel getOutgoingStatementsInfoSelectModel() throws ClientException {
        return new SelectDataModelImpl("cm_outgoing_relations", this.getOutgoingStatementsInfo(), null);
    }

    public void resetStatements() {
        this.incomingStatements = null;
        this.incomingStatementsInfo = null;
        this.outgoingStatements = null;
        this.outgoingStatementsInfo = null;
    }

    public Boolean getShowCreateForm() {
        return this.showCreateForm;
    }

    public void toggleCreateForm(ActionEvent event) {
        this.showCreateForm = this.showCreateForm == false;
    }

    public String getPredicateUri() {
        return this.predicateUri;
    }

    public void setPredicateUri(String predicateUri) {
        this.predicateUri = predicateUri;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    public List<String> getTargetCreationDocuments() {
        if (this.targetCreationDocuments == null) {
            this.targetCreationDocuments = new ArrayList<String>();
        }
        return this.targetCreationDocuments;
    }

    public void setTargetCreationDocuments(List<String> targetCreationDocuments) {
        this.targetCreationDocuments = targetCreationDocuments;
    }

    protected void resetCreateFormValues() {
        this.showCreateForm = false;
        this.predicateUri = null;
        this.comment = null;
        this.searchKeywords = null;
        this.targetCreationDocuments = null;
    }

    protected void notifyEvent(String eventId, DocumentModel source, Map<String, Serializable> options, String comment) {
        EventProducer evtProducer = null;
        try {
            evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to get EventProducer to send event notification", (Throwable)e);
        }
        DocumentEventContext docCtx = new DocumentEventContext(this.documentManager, this.documentManager.getPrincipal(), source);
        options.put("category", (Serializable)((Object)"relationNotificationCategory"));
        options.put("comment", (Serializable)((Object)comment));
        try {
            evtProducer.fireEvent(docCtx.newEvent(eventId));
        }
        catch (ClientException e) {
            log.error((Object)"Error while trying to send notification message", (Throwable)e);
        }
    }

    public DocumentModel getDocumentModel(String id) throws ClientException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return this.documentManager.getDocument((DocumentRef)new IdRef(id));
    }

    public List<DocumentModel> getDocumentRelationSuggestions(Object input) throws ClientException {
        try {
            String docId = this.navigationContext.getCurrentDocument().getId();
            QueryModel qm = this.queryModelActions.get(CURRENT_CASE_ITEM_RELATION_SEARCH_QUERYMODEL);
            Object[] params = new Object[]{docId, input};
            PagedDocumentsProvider pageProvider = qm.getResultsProvider(this.documentManager, params, null);
            return pageProvider.getCurrentPage();
        }
        catch (Exception e) {
            throw new ClientException("error searching for documents", (Throwable)e);
        }
    }

    public String addStatement() throws ClientException {
        DocumentModel currentDoc = this.getCurrentCaseItem();
        QNameResource documentResource = this.getDocumentResource(currentDoc);
        if (documentResource == null) {
            throw new ClientException("Document resource could not be retrieved");
        }
        ResourceImpl predicate = new ResourceImpl(this.predicateUri);
        List<String> targetCreationDocs = this.getTargetCreationDocuments();
        if (targetCreationDocs == null || targetCreationDocs.isEmpty()) {
            throw new ClientException("No target documents");
        }
        LiteralImpl commentLiteral = null;
        String eventComment = null;
        if (this.comment != null) {
            this.comment = this.comment.trim();
            if (this.comment.length() > 0) {
                eventComment = this.comment;
                commentLiteral = new LiteralImpl(eventComment);
            }
        }
        Literal now = RelationDate.getLiteralDate((Date)new Date());
        LiteralImpl authorLiteral = null;
        if (this.currentUser != null) {
            authorLiteral = new LiteralImpl(this.currentUser.getName());
        }
        ArrayList<StatementImpl> stmts = new ArrayList<StatementImpl>();
        String repositoryName = currentDoc.getRepositoryName();
        boolean alreadySet = false;
        boolean someSet = false;
        for (String targetDocId : targetCreationDocs) {
            String localName = repositoryName + "/" + targetDocId;
            QNameResourceImpl object = new QNameResourceImpl("http://www.nuxeo.org/document/uid/", localName);
            StatementImpl stmt = new StatementImpl((Node)documentResource, (Node)predicate, (Node)object);
            if (commentLiteral != null) {
                stmt.addProperty(RelationConstants.COMMENT, (Node)commentLiteral);
            }
            stmt.addProperty(RelationConstants.CREATION_DATE, (Node)now);
            stmt.addProperty(RelationConstants.MODIFICATION_DATE, (Node)now);
            if (authorLiteral != null) {
                stmt.addProperty(RelationConstants.AUTHOR, (Node)authorLiteral);
            }
            if (this.outgoingStatements.contains(stmt)) {
                alreadySet = true;
                continue;
            }
            someSet = true;
            stmts.add(stmt);
        }
        if (someSet) {
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            String currentLifeCycleState = currentDoc.getCurrentLifeCycleState();
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
            options.put("graph", (Serializable)((Object)"default"));
            this.notifyEvent("beforeRelationCreation", currentDoc, options, eventComment);
            this.relationManager.add("default", stmts);
            this.notifyEvent("afterRelationCreation", currentDoc, options, eventComment);
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.relation.created"), new Object[0]);
        }
        if (alreadySet) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("label.relation.already.exists"), new Object[0]);
        }
        this.resetStatements();
        this.resetCreateFormValues();
        return null;
    }

    public String deleteStatement(StatementInfo stmtInfo) throws ClientException {
        if (stmtInfo != null && this.outgoingStatementsInfo != null && this.outgoingStatementsInfo.contains(stmtInfo)) {
            Statement stmt = stmtInfo.getStatement();
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            DocumentModel source = this.getCurrentCaseItem();
            String currentLifeCycleState = source.getCurrentLifeCycleState();
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
            options.put("graph", (Serializable)((Object)"default"));
            this.notifyEvent("beforeRelationRemoval", source, options, null);
            ArrayList<Statement> stmts = new ArrayList<Statement>();
            stmts.add(stmt);
            this.relationManager.remove("default", stmts);
            this.notifyEvent("afterRelationRemoval", source, options, null);
            this.resetStatements();
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.relation.deleted"), new Object[0]);
        }
        return null;
    }

    @Override
    protected void resetCurrentCaseItemCache(DocumentModel cachedEmail, DocumentModel newEmail) throws ClientException {
        this.resetStatements();
        this.resetCreateFormValues();
    }
}

