/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.actionable.caselink;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.cm.caselink.ActionableCaseLink;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="actionableCaseLinkActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class ActionableCaseLinkActionsBean
extends CaseManagementContextBoundInstance {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;

    public String approveTask(DocumentModel caseLink) throws ClientException {
        ActionableCaseLink acl = (ActionableCaseLink)caseLink.getAdapter(ActionableCaseLink.class);
        DocumentRef ref = caseLink.getParentRef();
        acl.validate(this.documentManager);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.documentManager.getDocument(ref)});
        return this.navigationContext.navigateToDocument(this.getCurrentMailbox().getDocument());
    }

    public String rejectTask(DocumentModel caseLink) throws ClientException {
        ActionableCaseLink acl = (ActionableCaseLink)caseLink.getAdapter(ActionableCaseLink.class);
        DocumentRef ref = caseLink.getParentRef();
        acl.refuse(this.documentManager);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.documentManager.getDocument(ref)});
        return this.navigationContext.navigateToDocument(this.getCurrentMailbox().getDocument());
    }

    public boolean isShowAction(DocumentModel caseLink) throws ClientException {
        CaseLink cl = (CaseLink)caseLink.getAdapter(CaseLink.class);
        if (cl.isActionnable()) {
            ActionableCaseLink acl = (ActionableCaseLink)caseLink.getAdapter(ActionableCaseLink.class);
            return acl.isTodo();
        }
        return false;
    }
}

