/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.identity;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.identity.Base64;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;

public class SecurityHeaderGenerator {
    public static final String HASH_METHOD = "MD5";

    public static Map<String, String> getHeaders() throws ConnectSecurityError {
        String digest;
        String TS;
        String CTID;
        String CLID1;
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            CLID1 = LogicalInstanceIdentifier.instance().getCLID1();
            String CLID2 = LogicalInstanceIdentifier.instance().getCLID2();
            CTID = TechnicalInstanceIdentifier.instance().getCTID();
            TS = "" + System.currentTimeMillis();
            String toDigest = CLID2 + CTID + TS;
            digest = Base64.encodeBytes(MessageDigest.getInstance(HASH_METHOD).digest(toDigest.getBytes()));
        }
        catch (Exception e) {
            throw new ConnectSecurityError("Unable to contruct Security Headers", e);
        }
        headers.put("X-NUXEO-CONNECT-CLID", CLID1);
        headers.put("X-NUXEO-CONNECT-CTID", CTID);
        headers.put("X-NUXEO-CONNECT-TS", TS);
        headers.put("X-NUXEO-CONNECT-DIGEST", digest);
        headers.put("X-NUXEO-CONNECT-CLIENT-VERSION", NuxeoConnectClient.getVersion());
        headers.put("X-NUXEO-CONNECT-DIGEST-METHOD", HASH_METHOD);
        return headers;
    }
}

